/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf;

import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.WorkflowTypeRegistrationOptions;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinition;
import com.amazonaws.services.simpleworkflow.flow.generic.WorkflowDefinitionFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.CurrentDecisionContext;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import org.apache.camel.component.aws.swf.CamelWorkflowDefinition;
import org.apache.camel.component.aws.swf.SWFWorkflowConsumer;

public class CamelWorkflowDefinitionFactory
extends WorkflowDefinitionFactory {
    private SWFWorkflowConsumer swfWorkflowConsumer;
    private WorkflowType workflowType;
    private WorkflowTypeRegistrationOptions registrationOptions;
    private DataConverter dataConverter;

    public CamelWorkflowDefinitionFactory(SWFWorkflowConsumer swfWorkflowConsumer, WorkflowType workflowType, WorkflowTypeRegistrationOptions registrationOptions, DataConverter dataConverter) {
        this.swfWorkflowConsumer = swfWorkflowConsumer;
        this.workflowType = workflowType;
        this.registrationOptions = registrationOptions;
        this.dataConverter = dataConverter;
    }

    public WorkflowTypeRegistrationOptions getWorkflowRegistrationOptions() {
        return this.registrationOptions;
    }

    public WorkflowDefinition getWorkflowDefinition(DecisionContext context) throws Exception {
        CurrentDecisionContext.set((DecisionContext)context);
        return new CamelWorkflowDefinition(this.swfWorkflowConsumer, context, this.dataConverter);
    }

    public void deleteWorkflowDefinition(WorkflowDefinition instance) {
        CurrentDecisionContext.unset();
    }

    public WorkflowType getWorkflowType() {
        return this.workflowType;
    }
}

