/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.ringbuffer;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.ringbuffer.Ringbuffer;
import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultEndpoint;
import org.apache.camel.component.hazelcast.HazelcastDefaultProducer;
import org.apache.camel.component.hazelcast.HazelcastOperation;

public class HazelcastRingbufferProducer
extends HazelcastDefaultProducer {
    private final Ringbuffer<Object> ringbuffer;

    public HazelcastRingbufferProducer(HazelcastInstance hazelcastInstance, HazelcastDefaultEndpoint endpoint, String cacheName) {
        super(endpoint);
        this.ringbuffer = hazelcastInstance.getRingbuffer(cacheName);
    }

    public void process(Exchange exchange) throws Exception {
        HazelcastOperation operation = this.lookupOperation(exchange);
        switch (operation) {
            case READ_ONCE_HEAD: {
                this.readOnceHead(exchange);
                break;
            }
            case READ_ONCE_TAIL: {
                this.readOnceTail(exchange);
                break;
            }
            case CAPACITY: {
                this.getCapacity(exchange);
                break;
            }
            case REMAINING_CAPACITY: {
                this.getRemainingCapacity(exchange);
                break;
            }
            case ADD: {
                this.add(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("The value '%s' is not allowed for parameter '%s' on the RINGBUFFER.", new Object[]{operation, "CamelHazelcastOperationType"}));
            }
        }
        HazelcastComponentHelper.copyHeaders(exchange);
    }

    private void readOnceHead(Exchange exchange) throws InterruptedException {
        exchange.getOut().setBody(this.ringbuffer.readOne(this.ringbuffer.headSequence()));
    }

    private void readOnceTail(Exchange exchange) throws InterruptedException {
        exchange.getOut().setBody(this.ringbuffer.readOne(this.ringbuffer.tailSequence()));
    }

    private void getCapacity(Exchange exchange) throws InterruptedException {
        exchange.getOut().setBody((Object)this.ringbuffer.capacity());
    }

    private void getRemainingCapacity(Exchange exchange) throws InterruptedException {
        exchange.getOut().setBody((Object)this.ringbuffer.remainingCapacity());
    }

    private void add(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        exchange.getOut().setBody((Object)this.ringbuffer.add(body));
    }
}

