/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.component.weather.http.HttpClientConfigurer;
import org.apache.commons.httpclient.HttpClient;

public class CompositeHttpConfigurer
implements HttpClientConfigurer {
    private final List<HttpClientConfigurer> configurers = new ArrayList<HttpClientConfigurer>();

    public void addConfigurer(HttpClientConfigurer configurer) {
        if (configurer != null) {
            this.configurers.add(configurer);
        }
    }

    public void removeConfigurer(HttpClientConfigurer configurer) {
        this.configurers.remove(configurer);
    }

    @Override
    public HttpClient configureHttpClient(HttpClient client) {
        for (HttpClientConfigurer configurer : this.configurers) {
            configurer.configureHttpClient(client);
        }
        return client;
    }

    public List<HttpClientConfigurer> getConfigurers() {
        return Collections.unmodifiableList(this.configurers);
    }
}

