/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.openstack.keystone.producer;

import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.openstack.keystone.KeystoneEndpoint;
import org.apache.camel.component.openstack.keystone.producer.AbstractKeystoneProducer;
import org.apache.camel.util.StringHelper;
import org.openstack4j.api.Builders;
import org.openstack4j.api.OSClient;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.identity.v3.Project;
import org.openstack4j.model.identity.v3.builder.ProjectBuilder;

public class ProjectProducer
extends AbstractKeystoneProducer {
    public ProjectProducer(KeystoneEndpoint endpoint, OSClient client) {
        super(endpoint, client);
    }

    public void process(Exchange exchange) throws Exception {
        String operation;
        switch (operation = this.getOperation(exchange)) {
            case "create": {
                this.doCreate(exchange);
                break;
            }
            case "get": {
                this.doGet(exchange);
                break;
            }
            case "getAll": {
                this.doGetAll(exchange);
                break;
            }
            case "update": {
                this.doUpdate(exchange);
                break;
            }
            case "delete": {
                this.doDelete(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
    }

    private void doCreate(Exchange exchange) {
        Project in = this.messageToProject(exchange.getIn());
        Project out = this.osV3Client.identity().projects().create(in);
        exchange.getIn().setBody((Object)out);
    }

    private void doGet(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", String.class);
        StringHelper.notEmpty((String)id, (String)"Project ID");
        Project result = this.osV3Client.identity().projects().get(id);
        msg.setBody((Object)result);
    }

    private void doGetAll(Exchange exchange) {
        List out = this.osV3Client.identity().projects().list();
        exchange.getIn().setBody((Object)out);
    }

    private void doUpdate(Exchange exchange) {
        Message msg = exchange.getIn();
        Project in = this.messageToProject(msg);
        Project out = this.osV3Client.identity().projects().update(in);
        msg.setBody((Object)out);
    }

    private void doDelete(Exchange exchange) {
        Message msg = exchange.getIn();
        String id = (String)msg.getHeader("ID", String.class);
        StringHelper.notEmpty((String)id, (String)"Project ID");
        ActionResponse response = this.osV3Client.identity().projects().delete(id);
        this.checkFailure(response, msg, "Delete project with ID " + id);
    }

    private Project messageToProject(Message message) {
        Project project = (Project)message.getBody(Project.class);
        if (project == null) {
            Map headers = message.getHeaders();
            ProjectBuilder builder = Builders.project();
            StringHelper.notEmpty((String)((String)message.getHeader("name", String.class)), (String)"Name");
            builder.name((String)message.getHeader("name", String.class));
            if (headers.containsKey("domainId")) {
                builder.domainId((String)message.getHeader("domainId", String.class));
            }
            if (headers.containsKey("description")) {
                builder.description((String)message.getHeader("description", String.class));
            }
            if (headers.containsKey("parentId")) {
                builder.parentId((String)message.getHeader("parentId", String.class));
            }
            project = (Project)builder.build();
        }
        return project;
    }
}

