/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.sheets.stream;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.BatchGetValuesResponse;
import com.google.api.services.sheets.v4.model.Spreadsheet;
import com.google.api.services.sheets.v4.model.ValueRange;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamConfiguration;
import org.apache.camel.component.google.sheets.stream.GoogleSheetsStreamEndpoint;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleSheetsStreamConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleSheetsStreamConsumer.class);

    public GoogleSheetsStreamConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    protected GoogleSheetsStreamConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    protected Sheets getClient() {
        return this.getEndpoint().getClient();
    }

    public GoogleSheetsStreamEndpoint getEndpoint() {
        return (GoogleSheetsStreamEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        ArrayDeque<Exchange> answer = new ArrayDeque<Exchange>();
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getRange())) {
            Sheets.Spreadsheets.Values.BatchGet request = this.getClient().spreadsheets().values().batchGet(this.getConfiguration().getSpreadsheetId());
            request.setMajorDimension(this.getConfiguration().getMajorDimension());
            request.setValueRenderOption(this.getConfiguration().getValueRenderOption());
            if (this.getConfiguration().getRange().contains(",")) {
                request.setRanges(Arrays.stream(this.getConfiguration().getRange().split(",")).map(String::trim).collect(Collectors.toList()));
            } else {
                request.setRanges(Collections.singletonList(this.getConfiguration().getRange()));
            }
            BatchGetValuesResponse response = (BatchGetValuesResponse)request.execute();
            if (response.getValueRanges() != null) {
                if (this.getConfiguration().isSplitResults()) {
                    for (ValueRange valueRange2 : response.getValueRanges()) {
                        AtomicInteger rangeIndex = new AtomicInteger(1);
                        AtomicInteger valueIndex = new AtomicInteger();
                        valueRange2.getValues().stream().limit(this.getConfiguration().getMaxResults()).map(values -> this.getEndpoint().createExchange(rangeIndex.get(), valueIndex.incrementAndGet(), valueRange2.getRange(), valueRange2.getMajorDimension(), (List<Object>)values)).forEach(answer::add);
                        rangeIndex.incrementAndGet();
                    }
                } else {
                    AtomicInteger rangeIndex = new AtomicInteger();
                    response.getValueRanges().stream().limit(this.getConfiguration().getMaxResults()).map(valueRange -> this.getEndpoint().createExchange(rangeIndex.incrementAndGet(), (ValueRange)valueRange)).forEach(answer::add);
                }
            }
        } else {
            Sheets.Spreadsheets.Get request = this.getClient().spreadsheets().get(this.getConfiguration().getSpreadsheetId());
            request.setIncludeGridData(Boolean.valueOf(this.getConfiguration().isIncludeGridData()));
            Spreadsheet spreadsheet = (Spreadsheet)request.execute();
            answer.add(this.getEndpoint().createExchange(spreadsheet));
        }
        return this.processBatch(CastUtils.cast(answer));
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            this.getAsyncProcessor().process(exchange, doneSync -> LOG.trace("Processing exchange done"));
        }
        return total;
    }
}

