/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan.processor.idempotent;

import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ServiceSupport;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.api.BasicCacheContainer;
import org.infinispan.manager.DefaultCacheManager;

@ManagedResource(description="Infinispan based message id repository")
public class InfinispanIdempotentRepository
extends ServiceSupport
implements IdempotentRepository<Object> {
    private final String cacheName;
    private final BasicCacheContainer cacheContainer;
    private final boolean isManagedCacheContainer;
    private BasicCache<Object, Boolean> cache;

    public InfinispanIdempotentRepository(BasicCacheContainer cacheContainer, String cacheName) {
        this.cacheContainer = cacheContainer;
        this.cacheName = cacheName;
        this.isManagedCacheContainer = false;
    }

    public InfinispanIdempotentRepository(String cacheName) {
        this.cacheContainer = new DefaultCacheManager();
        this.cacheName = cacheName;
        this.isManagedCacheContainer = true;
    }

    public InfinispanIdempotentRepository() {
        this(null);
    }

    public static InfinispanIdempotentRepository infinispanIdempotentRepository(BasicCacheContainer cacheContainer, String processorName) {
        return new InfinispanIdempotentRepository(cacheContainer, processorName);
    }

    public static InfinispanIdempotentRepository infinispanIdempotentRepository(String processorName) {
        return new InfinispanIdempotentRepository(processorName);
    }

    public static InfinispanIdempotentRepository infinispanIdempotentRepository() {
        return new InfinispanIdempotentRepository();
    }

    @ManagedOperation(description="Adds the key to the store")
    public boolean add(Object key) {
        if (this.getCache().containsKey(key)) {
            return false;
        }
        Boolean put = (Boolean)this.getCache().put(key, (Object)true);
        return put == null;
    }

    @ManagedOperation(description="Does the store contain the given key")
    public boolean contains(Object key) {
        return this.getCache().containsKey(key);
    }

    @ManagedOperation(description="Remove the key from the store")
    public boolean remove(Object key) {
        return this.getCache().remove(key) != null;
    }

    @ManagedOperation(description="Clear the store")
    public void clear() {
        this.getCache().clear();
    }

    @ManagedAttribute(description="The processor name")
    public String getCacheName() {
        return this.cacheName;
    }

    public boolean confirm(Object key) {
        return true;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected void doShutdown() throws Exception {
        if (this.isManagedCacheContainer) {
            this.cacheContainer.stop();
        }
        super.doShutdown();
    }

    private BasicCache<Object, Boolean> getCache() {
        if (this.cache == null) {
            if (InfinispanUtil.isRemote(this.cacheContainer)) {
                RemoteCacheManager manager = InfinispanUtil.asRemote(this.cacheContainer);
                this.cache = this.cacheName != null ? manager.getCache(this.cacheName, true) : manager.getCache(true);
            } else {
                this.cache = this.cacheName != null ? this.cacheContainer.getCache(this.cacheName) : this.cacheContainer.getCache();
            }
        }
        return this.cache;
    }
}

