/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.base64.springboot;

import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.base64.Base64DataFormat;
import org.apache.camel.dataformat.base64.springboot.Base64DataFormatConfiguration;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spi.DataFormatFactory;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.DataFormatConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class, GroupConditions.class})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@EnableConfigurationProperties(value={DataFormatConfigurationProperties.class, Base64DataFormatConfiguration.class})
public class Base64DataFormatAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(Base64DataFormatAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private Base64DataFormatConfiguration configuration;
    @Autowired(required=false)
    private List<DataFormatCustomizer<Base64DataFormat>> customizers;

    @Bean(name={"base64-dataformat-factory"})
    @ConditionalOnMissingBean(value={Base64DataFormat.class})
    public DataFormatFactory configureBase64DataFormatFactory() throws Exception {
        return new DataFormatFactory(){

            public DataFormat newInstance() {
                CamelContextAware contextAware;
                Base64DataFormat dataformat = new Base64DataFormat();
                if (CamelContextAware.class.isAssignableFrom(Base64DataFormat.class) && (contextAware = (CamelContextAware)CamelContextAware.class.cast(dataformat)) != null) {
                    contextAware.setCamelContext(Base64DataFormatAutoConfiguration.this.camelContext);
                }
                try {
                    HashMap parameters = new HashMap();
                    IntrospectionSupport.getProperties((Object)((Object)Base64DataFormatAutoConfiguration.this.configuration), parameters, null, (boolean)false);
                    CamelPropertiesHelper.setCamelProperties((CamelContext)Base64DataFormatAutoConfiguration.this.camelContext, (Object)dataformat, parameters, (boolean)false);
                }
                catch (Exception e) {
                    throw new RuntimeCamelException((Throwable)e);
                }
                if (ObjectHelper.isNotEmpty((Object)Base64DataFormatAutoConfiguration.this.customizers)) {
                    for (DataFormatCustomizer customizer : Base64DataFormatAutoConfiguration.this.customizers) {
                        boolean useCustomizer = customizer instanceof HasId ? HierarchicalPropertiesEvaluator.evaluate((Environment)Base64DataFormatAutoConfiguration.this.applicationContext.getEnvironment(), (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.base64.customizer", ((HasId)customizer).getId()}) : HierarchicalPropertiesEvaluator.evaluate((Environment)Base64DataFormatAutoConfiguration.this.applicationContext.getEnvironment(), (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.base64.customizer"});
                        if (!useCustomizer) continue;
                        LOGGER.debug("Configure dataformat {}, with customizer {}", (Object)dataformat, (Object)customizer);
                        customizer.customize((DataFormat)dataformat);
                    }
                }
                return dataformat;
            }
        };
    }

    static class GroupConditions
    extends GroupCondition {
        public GroupConditions() {
            super("camel.dataformat", "camel.dataformat.base64");
        }
    }
}

