/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.javaspace;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import net.jini.core.entry.Entry;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.space.JavaSpace;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.javaspace.InEntry;
import org.apache.camel.component.javaspace.JavaSpaceEndpoint;
import org.apache.camel.component.javaspace.OutEntry;
import org.apache.camel.component.javaspace.TransactionHelper;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.ExchangeHelper;

class Task
implements Runnable {
    private final JavaSpaceEndpoint endpoint;
    private final Processor processor;
    private final JavaSpace javaSpace;
    private final TransactionHelper transactionHelper;
    private final long transactionTimeout;
    private final int verb;
    private final Entry template;

    Task(JavaSpaceEndpoint endpoint, Processor processor, JavaSpace javaSpace, TransactionHelper transactionHelper, long transactionTimeout, int verb, String templateId) throws Exception {
        this.endpoint = endpoint;
        this.processor = processor;
        this.javaSpace = javaSpace;
        this.transactionHelper = transactionHelper;
        this.transactionTimeout = transactionTimeout;
        this.verb = verb;
        if (templateId != null) {
            Entry tmpl = (Entry)this.endpoint.getCamelContext().getRegistry().lookupByName(templateId);
            this.template = javaSpace.snapshot(tmpl);
        } else {
            this.template = javaSpace.snapshot((Entry)new InEntry());
        }
    }

    @Override
    public void run() {
        Transaction tnx = null;
        try {
            DefaultExchange exchange = (DefaultExchange)this.endpoint.createExchange(ExchangePattern.InOut);
            Message message = exchange.getIn();
            if (this.transactionHelper != null) {
                tnx = this.transactionHelper.getJiniTransaction((long)this.transactionTimeout).transaction;
            }
            Entry entry = null;
            switch (this.verb) {
                case 0: {
                    entry = this.javaSpace.take(this.template, tnx, 100L);
                    break;
                }
                case 1: {
                    entry = this.javaSpace.read(this.template, tnx, 100L);
                    break;
                }
                default: {
                    throw new RuntimeCamelException("Wrong verb");
                }
            }
            if (entry != null) {
                if (entry instanceof InEntry) {
                    if (((InEntry)entry).binary.booleanValue()) {
                        message.setBody((Object)((InEntry)entry).buffer);
                    } else {
                        ByteArrayInputStream bis = new ByteArrayInputStream(((InEntry)entry).buffer);
                        ObjectInputStream ois = new ObjectInputStream(bis);
                        Object obj = ois.readObject();
                        message.setBody(obj);
                    }
                    this.processor.process((Exchange)exchange);
                    Message out = exchange.getOut();
                    if (out.getBody() != null && ExchangeHelper.isOutCapable((Exchange)exchange)) {
                        OutEntry replyCamelEntry = new OutEntry();
                        replyCamelEntry.correlationId = ((InEntry)entry).correlationId;
                        if (out.getBody() instanceof byte[]) {
                            replyCamelEntry.binary = true;
                            replyCamelEntry.buffer = (byte[])out.getBody();
                        } else {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream oos = new ObjectOutputStream(bos);
                            oos.writeObject(out.getBody());
                            replyCamelEntry.binary = false;
                            replyCamelEntry.buffer = bos.toByteArray();
                        }
                        this.javaSpace.write((Entry)replyCamelEntry, tnx, Long.MAX_VALUE);
                    }
                } else {
                    message.setBody((Object)entry, Entry.class);
                    this.processor.process((Exchange)exchange);
                }
            }
        }
        catch (Exception e) {
            if (tnx != null) {
                try {
                    tnx.abort();
                }
                catch (UnknownTransactionException e1) {
                    throw new RuntimeCamelException((Throwable)e1);
                }
                catch (CannotAbortException e1) {
                    throw new RuntimeCamelException((Throwable)e1);
                }
                catch (RemoteException e1) {
                    throw new RuntimeCamelException((Throwable)e1);
                }
            }
            throw new RuntimeCamelException((Throwable)e);
        }
        finally {
            if (tnx != null) {
                try {
                    tnx.commit();
                }
                catch (UnknownTransactionException e1) {
                    throw new RuntimeCamelException((Throwable)e1);
                }
                catch (RemoteException e1) {
                    throw new RuntimeCamelException((Throwable)e1);
                }
                catch (CannotCommitException e1) {
                    throw new RuntimeCamelException((Throwable)e1);
                }
            }
        }
    }
}

