/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.component.google.mail.GmailUsersDraftsEndpointConfiguration;
import org.apache.camel.component.google.mail.GmailUsersEndpointConfiguration;
import org.apache.camel.component.google.mail.GmailUsersHistoryEndpointConfiguration;
import org.apache.camel.component.google.mail.GmailUsersLabelsEndpointConfiguration;
import org.apache.camel.component.google.mail.GmailUsersMessagesAttachmentsEndpointConfiguration;
import org.apache.camel.component.google.mail.GmailUsersMessagesEndpointConfiguration;
import org.apache.camel.component.google.mail.GmailUsersThreadsEndpointConfiguration;
import org.apache.camel.component.google.mail.GoogleMailConfiguration;
import org.apache.camel.component.google.mail.internal.GmailUsersApiMethod;
import org.apache.camel.component.google.mail.internal.GmailUsersDraftsApiMethod;
import org.apache.camel.component.google.mail.internal.GmailUsersHistoryApiMethod;
import org.apache.camel.component.google.mail.internal.GmailUsersLabelsApiMethod;
import org.apache.camel.component.google.mail.internal.GmailUsersMessagesApiMethod;
import org.apache.camel.component.google.mail.internal.GmailUsersMessagesAttachmentsApiMethod;
import org.apache.camel.component.google.mail.internal.GmailUsersThreadsApiMethod;
import org.apache.camel.component.google.mail.internal.GoogleMailApiName;
import org.apache.camel.util.component.ApiCollection;
import org.apache.camel.util.component.ApiMethodHelper;

public final class GoogleMailApiCollection
extends ApiCollection<GoogleMailApiName, GoogleMailConfiguration> {
    private static GoogleMailApiCollection collection;

    private GoogleMailApiCollection() {
        HashMap aliases = new HashMap();
        HashMap<GoogleMailApiName, ApiMethodHelper> apiHelpers = new HashMap<GoogleMailApiName, ApiMethodHelper>();
        HashMap<Class<GmailUsersApiMethod>, GoogleMailApiName> apiMethods = new HashMap<Class<GmailUsersApiMethod>, GoogleMailApiName>();
        aliases.clear();
        List<String> nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(GoogleMailApiName.THREADS, new ApiMethodHelper(GmailUsersThreadsApiMethod.class, aliases, nullableArgs));
        apiMethods.put(GmailUsersThreadsApiMethod.class, GoogleMailApiName.THREADS);
        aliases.clear();
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(GoogleMailApiName.MESSAGES, new ApiMethodHelper(GmailUsersMessagesApiMethod.class, aliases, nullableArgs));
        apiMethods.put(GmailUsersMessagesApiMethod.class, GoogleMailApiName.MESSAGES);
        aliases.clear();
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(GoogleMailApiName.ATTACHMENTS, new ApiMethodHelper(GmailUsersMessagesAttachmentsApiMethod.class, aliases, nullableArgs));
        apiMethods.put(GmailUsersMessagesAttachmentsApiMethod.class, GoogleMailApiName.ATTACHMENTS);
        aliases.clear();
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(GoogleMailApiName.LABELS, new ApiMethodHelper(GmailUsersLabelsApiMethod.class, aliases, nullableArgs));
        apiMethods.put(GmailUsersLabelsApiMethod.class, GoogleMailApiName.LABELS);
        aliases.clear();
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(GoogleMailApiName.HISTORY, new ApiMethodHelper(GmailUsersHistoryApiMethod.class, aliases, nullableArgs));
        apiMethods.put(GmailUsersHistoryApiMethod.class, GoogleMailApiName.HISTORY);
        aliases.clear();
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(GoogleMailApiName.DRAFTS, new ApiMethodHelper(GmailUsersDraftsApiMethod.class, aliases, nullableArgs));
        apiMethods.put(GmailUsersDraftsApiMethod.class, GoogleMailApiName.DRAFTS);
        aliases.clear();
        nullableArgs = Arrays.asList(new String[0]);
        apiHelpers.put(GoogleMailApiName.USERS, new ApiMethodHelper(GmailUsersApiMethod.class, aliases, nullableArgs));
        apiMethods.put(GmailUsersApiMethod.class, GoogleMailApiName.USERS);
        this.setApiHelpers(apiHelpers);
        this.setApiMethods(apiMethods);
    }

    public GoogleMailConfiguration getEndpointConfiguration(GoogleMailApiName apiName) {
        GoogleMailConfiguration result = null;
        switch (apiName) {
            case THREADS: {
                result = new GmailUsersThreadsEndpointConfiguration();
                break;
            }
            case MESSAGES: {
                result = new GmailUsersMessagesEndpointConfiguration();
                break;
            }
            case ATTACHMENTS: {
                result = new GmailUsersMessagesAttachmentsEndpointConfiguration();
                break;
            }
            case LABELS: {
                result = new GmailUsersLabelsEndpointConfiguration();
                break;
            }
            case HISTORY: {
                result = new GmailUsersHistoryEndpointConfiguration();
                break;
            }
            case DRAFTS: {
                result = new GmailUsersDraftsEndpointConfiguration();
                break;
            }
            case USERS: {
                result = new GmailUsersEndpointConfiguration();
            }
        }
        return result;
    }

    public static synchronized GoogleMailApiCollection getCollection() {
        if (collection == null) {
            collection = new GoogleMailApiCollection();
        }
        return collection;
    }
}

