/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperConnectionManager;
import org.apache.camel.component.zookeeper.ZooKeeperEndpoint;
import org.apache.camel.component.zookeeper.ZooKeeperMessage;
import org.apache.camel.component.zookeeper.ZooKeeperUtils;
import org.apache.camel.component.zookeeper.operations.AnyOfOperations;
import org.apache.camel.component.zookeeper.operations.ChildrenChangedOperation;
import org.apache.camel.component.zookeeper.operations.DataChangedOperation;
import org.apache.camel.component.zookeeper.operations.ExistenceChangedOperation;
import org.apache.camel.component.zookeeper.operations.ExistsOperation;
import org.apache.camel.component.zookeeper.operations.GetChildrenOperation;
import org.apache.camel.component.zookeeper.operations.GetDataOperation;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.ZooKeeper;

public class ZooKeeperConsumer
extends DefaultConsumer {
    private final ZooKeeperConnectionManager zkm;
    private ZooKeeper connection;
    private ZooKeeperConfiguration configuration;
    private LinkedBlockingQueue<ZooKeeperOperation> operations = new LinkedBlockingQueue();
    private ExecutorService executor;
    private volatile boolean shuttingDown;

    public ZooKeeperConsumer(ZooKeeperEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.zkm = endpoint.getConnectionManager();
        this.configuration = endpoint.getConfiguration();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.connection = this.zkm.getConnection();
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("Connected to Zookeeper cluster %s", this.configuration.getConnectString()));
        }
        this.initializeConsumer();
        this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "Camel-Zookeeper OperationsExecutor", 1);
        OperationsExecutor opsService = new OperationsExecutor();
        this.executor.submit(opsService);
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.shuttingDown = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace(String.format("Shutting down zookeeper consumer of '%s'", this.configuration.getPath()));
        }
        this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdown(this.executor);
        this.zkm.shutdown();
    }

    private void initializeConsumer() {
        String node = this.configuration.getPath();
        if (this.configuration.isListChildren()) {
            this.initializeChildListingConsumer(node);
        } else {
            this.initializeDataConsumer(node);
        }
    }

    private void initializeDataConsumer(String node) {
        if (!this.shuttingDown) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Initializing consumption of data on node '%s'", node));
            }
            this.addBasicDataConsumeSequence(node);
        }
    }

    private void initializeChildListingConsumer(String node) {
        if (!this.shuttingDown) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Initializing child listing of node '%s'", node));
            }
            this.addBasicChildListingSequence(node);
        }
    }

    private Exchange createExchange(String path, OperationResult result, WatchedEvent watchedEvent) {
        Exchange exchange = this.getEndpoint().createExchange();
        ZooKeeperMessage in = new ZooKeeperMessage(this.getEndpoint().getCamelContext(), path, result.getStatistics(), watchedEvent);
        exchange.setIn((Message)in);
        if (result.isOk()) {
            in.setBody(result.getResult());
        } else {
            exchange.setException((Throwable)result.getException());
        }
        return exchange;
    }

    private void addBasicDataConsumeSequence(String node) {
        this.operations.clear();
        this.operations.add(new AnyOfOperations(node, new ExistsOperation(this.connection, node), new ExistenceChangedOperation(this.connection, node)));
        this.operations.add(new GetDataOperation(this.connection, node));
        this.operations.add(new DataChangedOperation(this.connection, node, false, this.configuration.isSendEmptyMessageOnDelete()));
    }

    private void addBasicChildListingSequence(String node) {
        this.operations.clear();
        this.operations.add(new AnyOfOperations(node, new ExistsOperation(this.connection, node), new ExistenceChangedOperation(this.connection, node)));
        this.operations.add(new GetChildrenOperation(this.connection, node));
        this.operations.add(new ChildrenChangedOperation(this.connection, node, false));
    }

    private class OperationsExecutor
    implements Runnable {
        private ZooKeeperOperation current;
        private WatchedEvent watchedEvent;

        private OperationsExecutor() {
        }

        @Override
        public void run() {
            while (ZooKeeperConsumer.this.isRunAllowed()) {
                block15: {
                    try {
                        this.current = (ZooKeeperOperation)ZooKeeperConsumer.this.operations.take();
                        if (!ZooKeeperConsumer.this.log.isTraceEnabled()) break block15;
                        ZooKeeperConsumer.this.log.trace(String.format("Processing '%s' operation", this.current.getClass().getSimpleName()));
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                String node = this.current.getNode();
                try {
                    OperationResult result = this.current.get();
                    if (ZooKeeperUtils.hasWatchedEvent(this.current)) {
                        this.watchedEvent = ZooKeeperUtils.getWatchedEvent(this.current);
                    }
                    if (result == null || !this.current.shouldProduceExchange()) continue;
                    ZooKeeperConsumer.this.getProcessor().process(ZooKeeperConsumer.this.createExchange(node, result, this.watchedEvent));
                    this.watchedEvent = null;
                }
                catch (Exception e) {
                    ZooKeeperConsumer.this.handleException(e);
                    this.backoffAndThenRestart();
                }
                finally {
                    if (!ZooKeeperConsumer.this.configuration.isRepeat()) continue;
                    try {
                        ZooKeeperConsumer.this.operations.offer(this.current.createCopy());
                    }
                    catch (Exception e) {
                        this.backoffAndThenRestart();
                    }
                }
            }
        }

        private void backoffAndThenRestart() {
            try {
                if (ZooKeeperConsumer.this.isRunAllowed()) {
                    Thread.sleep(ZooKeeperConsumer.this.configuration.getBackoff());
                    ZooKeeperConsumer.this.initializeConsumer();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

