/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail;

import com.google.api.services.gmail.Gmail;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.component.google.mail.BatchGoogleMailClientFactory;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.component.google.mail.GoogleMailComponentVerifierExtension;
import org.apache.camel.component.google.mail.GoogleMailConfiguration;
import org.apache.camel.component.google.mail.GoogleMailEndpoint;
import org.apache.camel.component.google.mail.internal.GoogleMailApiCollection;
import org.apache.camel.component.google.mail.internal.GoogleMailApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.component.AbstractApiComponent;
import org.apache.camel.util.component.ApiCollection;

public class GoogleMailComponent
extends AbstractApiComponent<GoogleMailApiName, GoogleMailConfiguration, GoogleMailApiCollection> {
    @Metadata(label="advanced")
    private Gmail client;
    @Metadata(label="advanced")
    private GoogleMailClientFactory clientFactory;

    public GoogleMailComponent() {
        super(GoogleMailEndpoint.class, GoogleMailApiName.class, (ApiCollection)GoogleMailApiCollection.getCollection());
        this.registerExtension((ComponentExtension)new GoogleMailComponentVerifierExtension());
    }

    public GoogleMailComponent(CamelContext context) {
        super(context, GoogleMailEndpoint.class, GoogleMailApiName.class, (ApiCollection)GoogleMailApiCollection.getCollection());
        this.registerExtension((ComponentExtension)new GoogleMailComponentVerifierExtension());
    }

    protected GoogleMailApiName getApiName(String apiNameStr) throws IllegalArgumentException {
        return GoogleMailApiName.fromValue(apiNameStr);
    }

    public Gmail getClient(GoogleMailConfiguration googleMailConfiguration) {
        if (this.client == null) {
            this.client = this.getClientFactory().makeClient(googleMailConfiguration.getClientId(), googleMailConfiguration.getClientSecret(), googleMailConfiguration.getApplicationName(), googleMailConfiguration.getRefreshToken(), googleMailConfiguration.getAccessToken());
        }
        return this.client;
    }

    public GoogleMailClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new BatchGoogleMailClientFactory();
        }
        return this.clientFactory;
    }

    public void setConfiguration(GoogleMailConfiguration configuration) {
        super.setConfiguration((Object)configuration);
    }

    public GoogleMailConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new GoogleMailConfiguration();
        }
        return (GoogleMailConfiguration)super.getConfiguration();
    }

    public void setClientFactory(GoogleMailClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    protected Endpoint createEndpoint(String uri, String methodName, GoogleMailApiName apiName, GoogleMailConfiguration endpointConfiguration) {
        endpointConfiguration.setApiName(apiName);
        endpointConfiguration.setMethodName(methodName);
        return new GoogleMailEndpoint(uri, this, apiName, methodName, endpointConfiguration);
    }
}

