/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.consumer;

import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.consumer.AbstractMessageHandler;
import org.apache.camel.spi.Synchronization;

public class InOutMessageHandler
extends AbstractMessageHandler {
    private Map<String, MessageProducer> producerCache = new TreeMap<String, MessageProducer>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public InOutMessageHandler(SjmsEndpoint endpoint, ExecutorService executor) {
        super(endpoint, executor);
    }

    public InOutMessageHandler(SjmsEndpoint endpoint, ExecutorService executor, Synchronization synchronization) {
        super(endpoint, executor, synchronization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Exchange exchange) {
        block26: {
            try {
                MessageProducer messageProducer = null;
                Object obj = exchange.getIn().getHeader("JMSReplyTo");
                if (obj != null) {
                    Destination replyTo;
                    if (this.isDestination(obj)) {
                        replyTo = (Destination)obj;
                    } else if (obj instanceof String) {
                        replyTo = this.getEndpoint().getDestinationCreationStrategy().createDestination(this.getSession(), (String)obj, this.isTopic());
                    } else {
                        throw new Exception("The value of JMSReplyTo must be a valid Destination or String.  Value provided: " + obj);
                    }
                    String destinationName = this.getDestinationName(replyTo);
                    try {
                        this.lock.readLock().lock();
                        if (this.producerCache.containsKey(destinationName)) {
                            messageProducer = this.producerCache.get(destinationName);
                        }
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                    if (messageProducer == null) {
                        try {
                            this.lock.writeLock().lock();
                            messageProducer = this.getSession().createProducer(replyTo);
                            this.producerCache.put(destinationName, messageProducer);
                        }
                        finally {
                            this.lock.writeLock().unlock();
                        }
                    }
                }
                MessageHandlerAsyncCallback callback = new MessageHandlerAsyncCallback(exchange, messageProducer);
                if (exchange.isFailed()) {
                    return;
                }
                if (this.isTransacted() || this.isSynchronous()) {
                    this.log.debug("Synchronous processing: Message[{}], Destination[{}] ", exchange.getIn().getBody(), (Object)this.getEndpoint().getEndpointUri());
                    try {
                        this.getProcessor().process(exchange);
                        break block26;
                    }
                    catch (Exception e) {
                        exchange.setException((Throwable)e);
                        break block26;
                    }
                    finally {
                        callback.done(true);
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Asynchronous processing: Message[{}], Destination[{}] ", exchange.getIn().getBody(), (Object)this.getEndpoint().getEndpointUri());
                }
                this.getProcessor().process(exchange, (AsyncCallback)callback);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("SjmsMessageConsumer invoked for Exchange id:{}", (Object)exchange.getExchangeId());
        }
    }

    @Override
    public void close() {
        for (Map.Entry<String, MessageProducer> entry : this.producerCache.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (JMSException e) {
                this.log.debug("Cached MessageProducer with key: " + entry.getKey() + " threw an unexpected exception. This exception is ignored.", (Throwable)e);
            }
        }
        this.producerCache.clear();
    }

    private boolean isDestination(Object object) {
        return object instanceof Destination;
    }

    private String getDestinationName(Destination destination) throws Exception {
        String answer = null;
        if (destination instanceof Queue) {
            answer = ((Queue)destination).getQueueName();
        } else if (destination instanceof Topic) {
            answer = ((Topic)destination).getTopicName();
        }
        return answer;
    }

    protected class MessageHandlerAsyncCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final MessageProducer localProducer;

        public MessageHandlerAsyncCallback(Exchange exchange, MessageProducer localProducer) {
            this.exchange = exchange;
            this.localProducer = localProducer;
        }

        public void done(boolean sync) {
            try {
                Message msg = this.exchange.hasOut() ? this.exchange.getOut() : this.exchange.getIn();
                javax.jms.Message response = InOutMessageHandler.this.getEndpoint().getBinding().makeJmsMessage(this.exchange, msg.getBody(), msg.getHeaders(), InOutMessageHandler.this.getSession(), null);
                response.setJMSCorrelationID((String)this.exchange.getIn().getHeader("JMSCorrelationID", String.class));
                this.localProducer.send(response);
            }
            catch (Exception e) {
                this.exchange.setException((Throwable)e);
            }
        }
    }
}

