/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rest.swagger;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.HttpMethod;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.parameters.Parameter;
import io.swagger.parser.SwaggerParser;
import io.swagger.util.Json;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.rest.swagger.RestSwaggerComponent;
import org.apache.camel.component.rest.swagger.RestSwaggerHelper;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.19.0", scheme="rest-swagger", title="REST Swagger", syntax="rest-swagger:specificationUri#operationId", label="rest,swagger,http", producerOnly=true)
public final class RestSwaggerEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(RestSwaggerEndpoint.class);
    Map<String, Object> parameters = Collections.emptyMap();
    private String assignedComponentName;
    @UriParam(description="API basePath, for example \"`/v2`\". Default is unset, if set overrides the value present in Swagger specification and in the component configuration.", defaultValue="", label="producer")
    @Metadata(required="false")
    private String basePath;
    @UriParam(description="Name of the Camel component that will perform the requests. The compnent must be present in Camel registry and it must implement RestProducerFactory service provider interface. If not set CLASSPATH is searched for single component that implements RestProducerFactory SPI. Overrides component configuration.", label="producer")
    @Metadata(required="false")
    private String componentName;
    @UriParam(description="What payload type this component capable of consuming. Could be one type, like `application/json` or multiple types as `application/json, application/xml; q=0.5` according to the RFC7231. This equates to the value of `Accept` HTTP header. If set overrides any value found in the Swagger specification and. in the component configuration", label="producer")
    private String consumes;
    @UriParam(description="Scheme hostname and port to direct the HTTP requests to in the form of `http[s]://hostname[:port]`. Can be configured at the endpoint, component or in the correspoding REST configuration in the Camel Context. If you give this component a name (e.g. `petstore`) that REST configuration is consulted first, `rest-swagger` next, and global configuration last. If set overrides any value found in the Swagger specification, RestConfiguration. Overrides all other  configuration.", label="producer")
    private String host;
    @UriPath(description="ID of the operation from the Swagger specification.", label="producer")
    @Metadata(required="true")
    private String operationId;
    @UriParam(description="What payload type this component is producing. For example `application/json` according to the RFC7231. This equates to the value of `Content-Type` HTTP header. If set overrides any value present in the Swagger specification. Overrides all other configuration.", label="producer")
    private String produces;
    @UriPath(description="Path to the Swagger specification file. The scheme, host base path are taken from this specification, but these can be overriden with properties on the component or endpoint level. If not given the component tries to load `swagger.json` resource. Note that the `host` defined on the component and endpoint of this Component should contain the scheme, hostname and optionally the port in the URI syntax (i.e. `https://api.example.com:8080`). Overrides component configuration.", defaultValue="swagger.json", defaultValueNote="By default loads `swagger.json` file", label="producer")
    private URI specificationUri = RestSwaggerComponent.DEFAULT_SPECIFICATION_URI;

    public RestSwaggerEndpoint() {
    }

    public RestSwaggerEndpoint(String uri, String remaining, RestSwaggerComponent component, Map<String, Object> parameters) {
        super(StringHelper.notEmpty((String)uri, (String)"uri"), (Component)ObjectHelper.notNull((Object)((Object)component), (String)"component"));
        this.parameters = parameters;
        this.assignedComponentName = StringHelper.before((String)uri, (String)":");
        URI componentSpecificationUri = component.getSpecificationUri();
        this.specificationUri = StringHelper.before((String)remaining, (String)"#", StringHelper::trimToNull).map(URI::create).orElse(Optional.ofNullable(componentSpecificationUri).orElse(RestSwaggerComponent.DEFAULT_SPECIFICATION_URI));
        this.operationId = Optional.ofNullable(StringHelper.after((String)remaining, (String)"#")).orElse(remaining);
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer not supported");
    }

    public Producer createProducer() throws Exception {
        CamelContext camelContext = this.getCamelContext();
        Swagger swagger = RestSwaggerEndpoint.loadSpecificationFrom(camelContext, this.specificationUri);
        Map paths = swagger.getPaths();
        for (Map.Entry pathEntry : paths.entrySet()) {
            Path path = (Path)pathEntry.getValue();
            Optional<Map.Entry> maybeOperationEntry = path.getOperationMap().entrySet().stream().filter(operationEntry -> this.operationId.equals(((Operation)operationEntry.getValue()).getOperationId())).findAny();
            if (!maybeOperationEntry.isPresent()) continue;
            Map.Entry operationEntry2 = maybeOperationEntry.get();
            Operation operation = (Operation)operationEntry2.getValue();
            Map<String, Parameter> pathParameters = operation.getParameters().stream().filter(p -> "path".equals(p.getIn())).collect(Collectors.toMap(Parameter::getName, Function.identity()));
            String uriTemplate = this.resolveUri((String)pathEntry.getKey(), pathParameters);
            HttpMethod httpMethod = (HttpMethod)operationEntry2.getKey();
            String method = httpMethod.name();
            return this.createProducerFor(swagger, operation, method, uriTemplate);
        }
        String supportedOperations = paths.values().stream().flatMap(p -> p.getOperations().stream()).map(Operation::getOperationId).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("The specified operation with ID: `" + this.operationId + "` cannot be found in the Swagger specification loaded from `" + this.specificationUri + "`. Operations defined in the specification are: " + supportedOperations);
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getConsumes() {
        return this.consumes;
    }

    public String getHost() {
        return this.host;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public String getProduces() {
        return this.produces;
    }

    public URI getSpecificationUri() {
        return this.specificationUri;
    }

    public boolean isLenientProperties() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBasePath(String basePath) {
        this.basePath = StringHelper.notEmpty((String)basePath, (String)"basePath");
    }

    public void setComponentName(String componentName) {
        this.componentName = StringHelper.notEmpty((String)componentName, (String)"componentName");
    }

    public void setConsumes(String consumes) {
        this.consumes = RestSwaggerHelper.isMediaRange(consumes, "consumes");
    }

    public void setHost(String host) {
        this.host = RestSwaggerHelper.isHostParam(host);
    }

    public void setOperationId(String operationId) {
        this.operationId = StringHelper.notEmpty((String)operationId, (String)"operationId");
    }

    public void setProduces(String produces) {
        this.produces = RestSwaggerHelper.isMediaRange(produces, "produces");
    }

    public void setSpecificationUri(URI specificationUri) {
        this.specificationUri = (URI)ObjectHelper.notNull((Object)specificationUri, (String)"specificationUri");
    }

    RestSwaggerComponent component() {
        return (RestSwaggerComponent)this.getComponent();
    }

    Producer createProducerFor(Swagger swagger, Operation operation, String method, String uriTemplate) throws Exception {
        String basePath = this.determineBasePath(swagger);
        StringBuilder componentEndpointUri = new StringBuilder(200).append("rest:").append(method).append(":").append(basePath).append(":").append(uriTemplate);
        CamelContext camelContext = this.getCamelContext();
        Endpoint endpoint = camelContext.getEndpoint(componentEndpointUri.toString());
        this.setProperties(endpoint, this.determineEndpointParameters(swagger, operation));
        return endpoint.createProducer();
    }

    String determineBasePath(Swagger swagger) {
        if (ObjectHelper.isNotEmpty((Object)this.basePath)) {
            return this.basePath;
        }
        String componentBasePath = this.component().getBasePath();
        if (ObjectHelper.isNotEmpty((Object)componentBasePath)) {
            return componentBasePath;
        }
        String specificationBasePath = swagger.getBasePath();
        if (ObjectHelper.isNotEmpty((Object)specificationBasePath)) {
            return specificationBasePath;
        }
        CamelContext camelContext = this.getCamelContext();
        RestConfiguration specificConfiguration = camelContext.getRestConfiguration(this.assignedComponentName, false);
        if (specificConfiguration != null && ObjectHelper.isNotEmpty((Object)specificConfiguration.getContextPath())) {
            return specificConfiguration.getContextPath();
        }
        RestConfiguration restConfiguration = camelContext.getRestConfiguration("rest-swagger", true);
        String restConfigurationBasePath = restConfiguration.getContextPath();
        if (ObjectHelper.isNotEmpty((Object)restConfigurationBasePath)) {
            return restConfigurationBasePath;
        }
        return "/";
    }

    String determineComponentName() {
        return Optional.ofNullable(this.componentName).orElse(this.component().getComponentName());
    }

    Map<String, Object> determineEndpointParameters(Swagger swagger, Operation operation) {
        String queryParameters;
        String determinedProducers;
        String host;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String componentName = this.determineComponentName();
        if (componentName != null) {
            parameters.put("componentName", componentName);
        }
        if ((host = this.determineHost(swagger)) != null) {
            parameters.put("host", host);
        }
        RestSwaggerComponent component = this.component();
        String determinedConsumes = RestSwaggerEndpoint.determineOption(swagger.getProduces(), operation.getProduces(), component.getConsumes(), this.consumes);
        if (ObjectHelper.isNotEmpty((Object)determinedConsumes)) {
            parameters.put("consumes", determinedConsumes);
        }
        if (ObjectHelper.isNotEmpty((Object)(determinedProducers = RestSwaggerEndpoint.determineOption(swagger.getConsumes(), operation.getConsumes(), component.getProduces(), this.produces)))) {
            parameters.put("produces", determinedProducers);
        }
        if (ObjectHelper.isNotEmpty((Object)(queryParameters = operation.getParameters().stream().filter(p -> "query".equals(p.getIn())).map(this::queryParameter).collect(Collectors.joining("&"))))) {
            parameters.put("queryParameters", queryParameters);
        }
        HashMap<String, Boolean> componentParameters = new HashMap<String, Boolean>();
        if (component.isUseGlobalSslContextParameters()) {
            componentParameters.put("useGlobalSslContextParameters", component.isUseGlobalSslContextParameters());
        }
        if (component.getSslContextParameters() != null) {
            componentParameters.put("sslContextParameters", (Boolean)component.getSslContextParameters());
        }
        if (!componentParameters.isEmpty()) {
            HashMap<String, HashMap<String, Boolean>> nestedParameters = new HashMap<String, HashMap<String, Boolean>>();
            nestedParameters.put("component", componentParameters);
            parameters.put("parameters", nestedParameters);
        }
        return parameters;
    }

    String determineHost(Swagger swagger) {
        if (ObjectHelper.isNotEmpty((Object)this.host)) {
            return this.host;
        }
        String componentHost = this.component().getHost();
        if (ObjectHelper.isNotEmpty((Object)componentHost)) {
            return componentHost;
        }
        String swaggerScheme = RestSwaggerEndpoint.pickBestScheme(this.specificationUri.getScheme(), swagger.getSchemes());
        String swaggerHost = swagger.getHost();
        if (ObjectHelper.isNotEmpty((Object)swaggerScheme) && ObjectHelper.isNotEmpty((Object)swaggerHost)) {
            return swaggerScheme + "://" + swaggerHost;
        }
        CamelContext camelContext = this.getCamelContext();
        RestConfiguration specificRestConfiguration = camelContext.getRestConfiguration(this.assignedComponentName, false);
        String specificConfigurationHost = RestSwaggerEndpoint.hostFrom(specificRestConfiguration);
        if (specificConfigurationHost != null) {
            return specificConfigurationHost;
        }
        RestConfiguration componentRestConfiguration = camelContext.getRestConfiguration("rest-swagger", false);
        String componentConfigurationHost = RestSwaggerEndpoint.hostFrom(componentRestConfiguration);
        if (componentConfigurationHost != null) {
            return componentConfigurationHost;
        }
        RestConfiguration globalRestConfiguration = camelContext.getRestConfiguration();
        String globalConfigurationHost = RestSwaggerEndpoint.hostFrom(globalRestConfiguration);
        if (globalConfigurationHost != null) {
            return globalConfigurationHost;
        }
        String specificationScheme = this.specificationUri.getScheme();
        if (this.specificationUri.isAbsolute() && specificationScheme.toLowerCase().startsWith("http")) {
            try {
                return new URI(this.specificationUri.getScheme(), this.specificationUri.getUserInfo(), this.specificationUri.getHost(), this.specificationUri.getPort(), null, null, null).toString();
            }
            catch (URISyntaxException e) {
                throw new IllegalStateException("Unable to create a new URI from: " + this.specificationUri, e);
            }
        }
        boolean areTheSame = "rest-swagger".equals(this.assignedComponentName);
        throw new IllegalStateException("Unable to determine destionation host for requests. The Swagger specification does not specify `scheme` and `host` parameters, the specification URI is not absolute with `http` or `https` scheme, and no RestConfigurations configured with `scheme`, `host` and `port` were found for `" + (areTheSame ? "rest-swagger` component" : this.assignedComponentName + "` or `rest-swagger` components") + " and there is no global RestConfiguration with those properties");
    }

    String literalPathParameterValue(Parameter parameter) {
        String name = parameter.getName();
        String valueStr = String.valueOf(this.parameters.get(name));
        String encoded = UnsafeUriCharactersEncoder.encode((String)valueStr);
        return encoded;
    }

    String literalQueryParameterValue(Parameter parameter) {
        String name = parameter.getName();
        String valueStr = String.valueOf(this.parameters.get(name));
        String encoded = UnsafeUriCharactersEncoder.encode((String)valueStr);
        return name + "=" + encoded;
    }

    String queryParameter(Parameter parameter) {
        String name = parameter.getName();
        if (ObjectHelper.isEmpty((Object)name)) {
            return "";
        }
        if (this.parameters.containsKey(name)) {
            return this.literalQueryParameterValue(parameter);
        }
        return RestSwaggerEndpoint.queryParameterExpression(parameter);
    }

    String resolveUri(String uriTemplate, Map<String, Parameter> pathParameters) {
        if (pathParameters.isEmpty()) {
            return uriTemplate;
        }
        int start = uriTemplate.indexOf(123);
        if (start == -1) {
            return uriTemplate;
        }
        int pos = 0;
        StringBuilder resolved = new StringBuilder(uriTemplate.length() * 2);
        while (start != -1) {
            resolved.append(uriTemplate.substring(pos, start));
            int end = uriTemplate.indexOf(125, start);
            String name = uriTemplate.substring(start + 1, end);
            if (this.parameters.containsKey(name)) {
                Parameter parameter = pathParameters.get(name);
                String value = this.literalPathParameterValue(parameter);
                resolved.append((Object)value);
            } else {
                resolved.append('{').append(name).append('}');
            }
            pos = end + 1;
            start = uriTemplate.indexOf(123, pos);
        }
        if (pos < uriTemplate.length()) {
            resolved.append(uriTemplate.substring(pos));
        }
        return resolved.toString();
    }

    static String determineOption(List<String> specificationLevel, List<String> operationLevel, String componentLevel, String endpointLevel) {
        if (ObjectHelper.isNotEmpty((Object)endpointLevel)) {
            return endpointLevel;
        }
        if (ObjectHelper.isNotEmpty((Object)componentLevel)) {
            return componentLevel;
        }
        if (operationLevel != null && !operationLevel.isEmpty()) {
            return String.join((CharSequence)", ", operationLevel);
        }
        if (specificationLevel != null && !specificationLevel.isEmpty()) {
            return String.join((CharSequence)", ", specificationLevel);
        }
        return null;
    }

    static String hostFrom(RestConfiguration restConfiguration) {
        if (restConfiguration == null) {
            return null;
        }
        String scheme = restConfiguration.getScheme();
        String host = restConfiguration.getHost();
        int port = restConfiguration.getPort();
        if (scheme == null || host == null) {
            return null;
        }
        StringBuilder answer = new StringBuilder(scheme).append("://").append(host);
        if (!(port <= 0 || "http".equalsIgnoreCase(scheme) && port == 80 || "https".equalsIgnoreCase(scheme) && port == 443)) {
            answer.append(':').append(port);
        }
        return answer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Swagger loadSpecificationFrom(CamelContext camelContext, URI uri) throws IOException {
        ObjectMapper mapper = Json.mapper();
        SwaggerParser swaggerParser = new SwaggerParser();
        String uriAsString = uri.toString();
        try (InputStream stream = ResourceHelper.resolveMandatoryResourceAsInputStream((CamelContext)camelContext, (String)uriAsString);){
            JsonNode node = mapper.readTree(stream);
            Swagger swagger = swaggerParser.read(node);
            return swagger;
        }
        catch (IOException e) {
            Swagger swagger2 = swaggerParser.read(uriAsString);
            if (swagger2 == null) throw new IllegalArgumentException("The given Swagger specification could not be loaded from `" + uri + "`. Tried loading using Camel's resource resolution and using Swagger's own resource resolution. Swagger tends to swallow exceptions while parsing, try specifying Java system property `debugParser` (e.g. `-DdebugParser=true`), the exception that occured when loading using Camel's resource loader follows", e);
            return swagger2;
        }
    }

    static String pickBestScheme(String specificationScheme, List<Scheme> schemes) {
        if (schemes != null && !schemes.isEmpty()) {
            if (schemes.contains(Scheme.HTTPS)) {
                return "https";
            }
            if (schemes.contains(Scheme.HTTP)) {
                return "http";
            }
        }
        if (specificationScheme != null) {
            return specificationScheme;
        }
        return null;
    }

    static String queryParameterExpression(Parameter parameter) {
        String name = parameter.getName();
        StringBuilder expression = new StringBuilder(name).append("={").append(name);
        if (!parameter.getRequired()) {
            expression.append('?');
        }
        expression.append('}');
        return expression.toString();
    }
}

