/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ssh;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ssh.SshConfiguration;
import org.apache.camel.component.ssh.SshEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.sshd.common.keyprovider.KeyPairProvider;

public class SshComponent
extends UriEndpointComponent {
    @Metadata(label="advanced")
    private SshConfiguration configuration = new SshConfiguration();

    public SshComponent() {
        super(SshEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        URI u = new URI(uri);
        SshConfiguration newConfig = this.configuration.copy();
        newConfig.configure(u);
        SshEndpoint endpoint = new SshEndpoint(uri, this, newConfig);
        this.setProperties(endpoint.getConfiguration(), parameters);
        return endpoint;
    }

    public SshConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SshConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getHost() {
        return this.getConfiguration().getHost();
    }

    public void setHost(String host) {
        this.getConfiguration().setHost(host);
    }

    public int getPort() {
        return this.getConfiguration().getPort();
    }

    public void setPort(int port) {
        this.getConfiguration().setPort(port);
    }

    public String getUsername() {
        return this.getConfiguration().getUsername();
    }

    @Metadata(label="security", secret=true)
    public void setUsername(String username) {
        this.getConfiguration().setUsername(username);
    }

    public String getPassword() {
        return this.getConfiguration().getPassword();
    }

    @Metadata(label="security", secret=true)
    public void setPassword(String password) {
        this.getConfiguration().setPassword(password);
    }

    public String getPollCommand() {
        return this.getConfiguration().getPollCommand();
    }

    public void setPollCommand(String pollCommand) {
        this.getConfiguration().setPollCommand(pollCommand);
    }

    public KeyPairProvider getKeyPairProvider() {
        return this.getConfiguration().getKeyPairProvider();
    }

    @Metadata(label="security")
    public void setKeyPairProvider(KeyPairProvider keyPairProvider) {
        this.getConfiguration().setKeyPairProvider(keyPairProvider);
    }

    public String getKeyType() {
        return this.getConfiguration().getKeyType();
    }

    @Metadata(label="security")
    public void setKeyType(String keyType) {
        this.getConfiguration().setKeyType(keyType);
    }

    public long getTimeout() {
        return this.getConfiguration().getTimeout();
    }

    public void setTimeout(long timeout) {
        this.getConfiguration().setTimeout(timeout);
    }

    @Deprecated
    public String getCertFilename() {
        return this.getConfiguration().getCertFilename();
    }

    @Deprecated
    @Metadata(label="security")
    public void setCertFilename(String certFilename) {
        this.getConfiguration().setCertFilename(certFilename);
    }

    public String getCertResource() {
        return this.getConfiguration().getCertResource();
    }

    @Metadata(label="security")
    public void setCertResource(String certResource) {
        this.getConfiguration().setCertResource(certResource);
    }

    @Metadata(label="advanced")
    public void setChannelType(String channelType) {
        this.getConfiguration().setChannelType(channelType);
    }

    @Metadata(label="advanced")
    public void setShellPrompt(String shellPrompt) {
        this.getConfiguration().setShellPrompt(shellPrompt);
    }

    @Metadata(label="advanced")
    public void setSleepForShellPrompt(long sleepForShellPrompt) {
        this.getConfiguration().setSleepForShellPrompt(sleepForShellPrompt);
    }
}

