/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.SpringIntegrationEndpoint;
import org.apache.camel.component.spring.integration.SpringIntegrationMessage;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.core.DestinationResolver;

public class SpringIntegrationConsumer
extends DefaultConsumer
implements MessageHandler {
    private final SpringCamelContext context;
    private final DestinationResolver<MessageChannel> destinationResolver;
    private SubscribableChannel inputChannel;
    private MessageChannel outputChannel;

    public SpringIntegrationConsumer(SpringIntegrationEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.context = (SpringCamelContext)endpoint.getCamelContext();
        this.destinationResolver = new BeanFactoryChannelResolver((BeanFactory)this.context.getApplicationContext());
    }

    public SpringIntegrationEndpoint getEndpoint() {
        return (SpringIntegrationEndpoint)super.getEndpoint();
    }

    protected void doStop() throws Exception {
        this.inputChannel.unsubscribe((MessageHandler)this);
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getEndpoint().getMessageChannel() == null) {
            String inputChannelName = this.getEndpoint().getDefaultChannel();
            if (ObjectHelper.isEmpty((Object)inputChannelName)) {
                inputChannelName = this.getEndpoint().getInputChannel();
            }
            StringHelper.notEmpty((String)inputChannelName, (String)"inputChannelName", (Object)((Object)this.getEndpoint()));
            this.inputChannel = (SubscribableChannel)this.destinationResolver.resolveDestination(inputChannelName);
        } else {
            this.inputChannel = (SubscribableChannel)this.getEndpoint().getMessageChannel();
        }
        if (this.inputChannel == null) {
            throw new IllegalArgumentException("Cannot resolve InputChannel on " + (Object)((Object)this.getEndpoint()));
        }
        if (this.getEndpoint().isInOut()) {
            StringHelper.notEmpty((String)this.getEndpoint().getOutputChannel(), (String)"OutputChannel", (Object)((Object)this.getEndpoint()));
            this.outputChannel = (MessageChannel)this.destinationResolver.resolveDestination(this.getEndpoint().getOutputChannel());
            if (this.outputChannel == null) {
                throw new IllegalArgumentException("Cannot resolve OutputChannel on " + (Object)((Object)this.getEndpoint()));
            }
        }
        this.inputChannel.subscribe((MessageHandler)this);
    }

    public void handleMessage(org.springframework.messaging.Message<?> siInMessage) {
        Exchange exchange = this.getEndpoint().createExchange(this.getEndpoint().isInOut() ? ExchangePattern.InOut : ExchangePattern.InOnly);
        exchange.setIn((Message)new SpringIntegrationMessage(siInMessage));
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            return;
        }
        if (this.getEndpoint().isInOut()) {
            MessageChannel reply = null;
            Object returnAddress = siInMessage.getHeaders().getReplyChannel();
            if (returnAddress != null) {
                if (returnAddress instanceof String) {
                    reply = (MessageChannel)this.context.getApplicationContext().getBean((String)returnAddress, MessageChannel.class);
                } else if (returnAddress instanceof MessageChannel) {
                    reply = (MessageChannel)returnAddress;
                }
            } else {
                reply = this.outputChannel;
                if (reply == null) {
                    throw new IllegalArgumentException("OutputChannel has not been configured on " + (Object)((Object)this.getEndpoint()));
                }
            }
            if (reply == null) {
                throw new IllegalArgumentException("Cannot resolve ReplyChannel from message: " + siInMessage);
            }
            org.springframework.messaging.Message<?> siOutMessage = SpringIntegrationBinding.storeToSpringIntegrationMessage(exchange.getOut());
            this.log.debug("Sending {} to ReplyChannel: {}", siOutMessage, (Object)reply);
            reply.send(siOutMessage);
        }
    }
}

