/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.model;

import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.camel.bam.model.ActivityDefinition;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.model.TemporalEntity;
import org.apache.camel.bam.processor.ProcessContext;
import org.apache.camel.bam.rules.ActivityRules;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="CAMEL_ACTIVITYSTATE")
public class ActivityState
extends TemporalEntity {
    private static final Logger LOG = LoggerFactory.getLogger(ActivityState.class);
    private ProcessInstance processInstance;
    private Integer receivedMessageCount = 0;
    private ActivityDefinition activityDefinition;
    private Date timeExpected;
    private Date timeOverdue;
    private Integer escalationLevel = 0;

    @Override
    public String toString() {
        return "ActivityState[" + this.getId() + " on " + this.getProcessInstance() + " " + this.getActivityDefinition() + "]";
    }

    public synchronized void processExchange(ActivityRules activityRules, ProcessContext context) throws Exception {
        int expectedMessages;
        int messageCount = 0;
        Integer count = this.getReceivedMessageCount();
        if (count != null) {
            messageCount = count;
        }
        this.setReceivedMessageCount(++messageCount);
        if (messageCount == 1) {
            this.onFirstMessage(context);
        }
        if (messageCount == (expectedMessages = activityRules.getExpectedMessages())) {
            this.onExpectedMessage(context);
        } else if (messageCount > expectedMessages) {
            this.onExcessMessage(context);
        }
    }

    public boolean isActivity(ActivityRules activityRules) {
        return ObjectHelper.equal((Object)this.getActivityDefinition(), (Object)activityRules.getActivityDefinition());
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
        processInstance.getActivityStates().add(this);
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    public ActivityDefinition getActivityDefinition() {
        return this.activityDefinition;
    }

    public void setActivityDefinition(ActivityDefinition activityDefinition) {
        this.activityDefinition = activityDefinition;
    }

    public Integer getEscalationLevel() {
        return this.escalationLevel;
    }

    public void setEscalationLevel(Integer escalationLevel) {
        this.escalationLevel = escalationLevel;
    }

    public Integer getReceivedMessageCount() {
        return this.receivedMessageCount;
    }

    public void setReceivedMessageCount(Integer receivedMessageCount) {
        this.receivedMessageCount = receivedMessageCount;
    }

    @Temporal(value=TemporalType.TIME)
    public Date getTimeExpected() {
        return this.timeExpected;
    }

    public void setTimeExpected(Date timeExpected) {
        this.timeExpected = timeExpected;
    }

    @Temporal(value=TemporalType.TIME)
    public Date getTimeOverdue() {
        return this.timeOverdue;
    }

    public void setTimeOverdue(Date timeOverdue) {
        this.timeOverdue = timeOverdue;
    }

    @Override
    public void setTimeCompleted(Date timeCompleted) {
        super.setTimeCompleted(timeCompleted);
        if (timeCompleted != null) {
            this.setEscalationLevel(-1);
        }
    }

    @Transient
    public String getCorrelationKey() {
        ProcessInstance pi = this.getProcessInstance();
        if (pi == null) {
            return null;
        }
        return pi.getCorrelationKey();
    }

    protected void onFirstMessage(ProcessContext context) {
        if (!this.isStarted()) {
            this.setTimeStarted(this.currentTime());
            context.onStarted(this);
            LOG.debug("Activity first message: {}", (Object)this);
        }
    }

    protected void onExpectedMessage(ProcessContext context) {
        if (!this.isCompleted()) {
            this.setTimeCompleted(this.currentTime());
            this.setTimeOverdue(null);
            context.onCompleted(this);
            LOG.debug("Activity complete: {}", (Object)this);
        }
    }

    protected void onExcessMessage(ProcessContext context) {
    }

    protected Date currentTime() {
        return new Date();
    }
}

