/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yql;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.yql.YqlEndpoint;
import org.apache.camel.component.yql.client.YqlClient;
import org.apache.camel.component.yql.client.YqlResponse;
import org.apache.camel.component.yql.configuration.YqlConfiguration;
import org.apache.camel.component.yql.exception.YqlHttpException;
import org.apache.camel.impl.DefaultProducer;

public class YqlProducer
extends DefaultProducer {
    public static final String CAMEL_YQL_HTTP_STATUS = "CamelYqlHttpStatus";
    public static final String CAMEL_YQL_HTTP_REQUEST = "CamelYqlHttpRequest";
    private final YqlEndpoint endpoint;
    private final YqlClient yqlClient;

    YqlProducer(YqlEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.yqlClient = new YqlClient(endpoint.getHttpClient());
    }

    public void process(Exchange exchange) throws Exception {
        YqlConfiguration configuration = this.endpoint.getConfiguration();
        YqlResponse yqlResponse = this.yqlClient.get(configuration);
        if (configuration.isThrowExceptionOnFailure() && yqlResponse.getStatus() != 200) {
            throw YqlHttpException.failedWith(yqlResponse.getStatus(), yqlResponse.getBody(), yqlResponse.getHttpRequest());
        }
        exchange.getIn().setHeader(CAMEL_YQL_HTTP_STATUS, (Object)yqlResponse.getStatus());
        exchange.getIn().setHeader(CAMEL_YQL_HTTP_REQUEST, (Object)yqlResponse.getHttpRequest());
        exchange.getIn().setBody((Object)yqlResponse.getBody());
    }
}

