/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yql;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.yql.YqlComponent;
import org.apache.camel.component.yql.YqlProducer;
import org.apache.camel.component.yql.configuration.YqlConfiguration;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

@UriEndpoint(firstVersion="2.21.0", scheme="yql", title="Yahoo Query Language", syntax="yql:query", producerOnly=true, label="cloud")
public class YqlEndpoint
extends DefaultEndpoint {
    private final HttpClientConnectionManager connectionManager;
    private CloseableHttpClient httpClient;
    @UriParam
    private final YqlConfiguration configuration;

    public YqlEndpoint(String uri, YqlComponent component, YqlConfiguration configuration, HttpClientConnectionManager connectionManager) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.connectionManager = connectionManager;
    }

    public Producer createProducer() throws Exception {
        return new YqlProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Consumer is not supported for YQL component");
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStop() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
    }

    synchronized CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClients.custom().setConnectionManager(this.connectionManager).build();
        }
        return this.httpClient;
    }

    YqlConfiguration getConfiguration() {
        return this.configuration;
    }
}

