/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xchange;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.xchange.XChangeConfiguration;
import org.apache.camel.component.xchange.XChangeEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;

public class XChangeMarketDataProducer
extends DefaultProducer {
    public XChangeMarketDataProducer(XChangeEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public XChangeEndpoint getEndpoint() {
        return (XChangeEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        XChangeEndpoint endpoint = this.getEndpoint();
        XChangeConfiguration.XChangeMethod method = endpoint.getConfiguration().getMethod();
        if (XChangeConfiguration.XChangeMethod.ticker == method) {
            CurrencyPair pair = (CurrencyPair)exchange.getIn().getHeader("CurrencyPair", CurrencyPair.class);
            pair = pair != null ? pair : (CurrencyPair)exchange.getMessage().getBody(CurrencyPair.class);
            pair = pair != null ? pair : endpoint.getConfiguration().getCurrencyPair();
            Ticker ticker = endpoint.getTicker(pair);
            exchange.getMessage().setBody((Object)ticker);
        }
    }
}

