/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.slack.SlackEndpoint;
import org.apache.camel.component.slack.utils.SlackUtils;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlackConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(SlackConsumer.class);
    private SlackEndpoint slackEndpoint;
    private String timestamp;
    private String channelId;

    public SlackConsumer(SlackEndpoint endpoint, Processor processor) throws IOException, ParseException {
        super((Endpoint)endpoint, processor);
        this.slackEndpoint = endpoint;
        this.channelId = this.getChannelId(this.slackEndpoint.getChannel());
    }

    protected int poll() throws Exception {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
        HttpPost httpPost = new HttpPost(this.slackEndpoint.getServerUrl() + "/api/channels.history");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("channel", this.channelId));
        if (ObjectHelper.isNotEmpty((Object)this.timestamp)) {
            params.add(new BasicNameValuePair("oldest", this.timestamp));
        }
        params.add(new BasicNameValuePair("count", this.slackEndpoint.getMaxResults()));
        params.add(new BasicNameValuePair("token", this.slackEndpoint.getToken()));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        String jsonString = SlackUtils.readResponse(response);
        JSONParser parser = new JSONParser();
        JSONObject c = (JSONObject)parser.parse(jsonString);
        List list = (List)c.get((Object)"messages");
        Queue<Exchange> exchanges = this.createExchanges(list);
        return this.processBatch(CastUtils.cast(exchanges));
    }

    private Queue<Exchange> createExchanges(List list) {
        LinkedList<Exchange> answer = new LinkedList<Exchange>();
        if (ObjectHelper.isNotEmpty((Object)list)) {
            Iterator it = list.iterator();
            int i = 0;
            while (it.hasNext()) {
                Object object = it.next();
                JSONObject singleMess = (JSONObject)object;
                if (i == 0) {
                    this.timestamp = (String)singleMess.get((Object)"ts");
                }
                ++i;
                Exchange exchange = this.slackEndpoint.createExchange(singleMess);
                answer.add(exchange);
            }
        }
        return answer;
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        int total = exchanges.size();
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            Exchange exchange = (Exchange)ObjectHelper.cast(Exchange.class, (Object)exchanges.poll());
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            this.getAsyncProcessor().process(exchange, new AsyncCallback(){

                public void done(boolean doneSync) {
                    LOG.trace("Processing exchange done");
                }
            });
        }
        return total;
    }

    private String getChannelId(String channel) throws IOException, ParseException {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
        HttpPost httpPost = new HttpPost(this.slackEndpoint.getServerUrl() + "/api/channels.list");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("token", this.slackEndpoint.getToken()));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        HttpResponse response = client.execute((HttpUriRequest)httpPost);
        String jsonString = SlackUtils.readResponse(response);
        JSONParser parser = new JSONParser();
        JSONObject c = (JSONObject)parser.parse(jsonString);
        List list = (List)c.get((Object)"channels");
        Iterator it = list.iterator();
        boolean i = false;
        while (it.hasNext()) {
            Object object = it.next();
            JSONObject singleChannel = (JSONObject)object;
            if (singleChannel.get((Object)"name") == null || !singleChannel.get((Object)"name").equals(channel) || singleChannel.get((Object)"id") == null) continue;
            return (String)singleChannel.get((Object)"id");
        }
        return jsonString;
    }
}

