/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.pubsub;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.google.pubsub.GooglePubsubConnectionFactory;
import org.apache.camel.component.google.pubsub.GooglePubsubEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class GooglePubsubComponent
extends UriEndpointComponent {
    private GooglePubsubConnectionFactory connectionFactory;

    public GooglePubsubComponent() {
        super(GooglePubsubEndpoint.class);
    }

    public GooglePubsubComponent(CamelContext context) {
        super(context, GooglePubsubEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String[] parts = remaining.split(":");
        if (parts.length < 2) {
            throw new IllegalArgumentException("Google PubSub Endpoint format \"projectId:destinationName[:subscriptionName]\"");
        }
        GooglePubsubEndpoint pubsubEndpoint = new GooglePubsubEndpoint(uri, (Component)this, remaining);
        pubsubEndpoint.setProjectId(parts[0]);
        pubsubEndpoint.setDestinationName(parts[1]);
        this.setProperties((Object)pubsubEndpoint, parameters);
        return pubsubEndpoint;
    }

    public GooglePubsubConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = new GooglePubsubConnectionFactory();
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(GooglePubsubConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

