/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloClientComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientComponent.class);
    private final Map<String, MiloClientConnection> cache = new HashMap<String, MiloClientConnection>();
    private final Multimap<String, MiloClientEndpoint> connectionMap = HashMultimap.create();
    private MiloClientConfiguration defaultConfiguration = new MiloClientConfiguration();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MiloClientConfiguration configuration = new MiloClientConfiguration(this.defaultConfiguration);
        configuration.setEndpointUri(remaining);
        this.setProperties(configuration, parameters);
        return this.createEndpoint(uri, configuration, parameters);
    }

    private synchronized MiloClientEndpoint createEndpoint(String uri, MiloClientConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String cacheId = configuration.toCacheId();
        MiloClientConnection connection = this.cache.get(cacheId);
        if (connection == null) {
            LOG.info("Cache miss - creating new connection instance: {}", (Object)cacheId);
            connection = new MiloClientConnection(configuration);
            this.cache.put(cacheId, connection);
        }
        MiloClientEndpoint endpoint = new MiloClientEndpoint(uri, this, connection, configuration.getEndpointUri());
        this.setProperties((Object)endpoint, parameters);
        this.connectionMap.put((Object)cacheId, (Object)endpoint);
        return endpoint;
    }

    public void setDefaultConfiguration(MiloClientConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void setApplicationName(String applicationName) {
        this.defaultConfiguration.setApplicationName(applicationName);
    }

    public void setApplicationUri(String applicationUri) {
        this.defaultConfiguration.setApplicationUri(applicationUri);
    }

    public void setProductUri(String productUri) {
        this.defaultConfiguration.setProductUri(productUri);
    }

    public void setReconnectTimeout(Long reconnectTimeout) {
        this.defaultConfiguration.setRequestTimeout(reconnectTimeout);
    }

    public synchronized void disposed(MiloClientEndpoint endpoint) {
        MiloClientConnection connection = endpoint.getConnection();
        this.connectionMap.remove((Object)connection.getConnectionId(), (Object)endpoint);
        if (!this.connectionMap.containsKey((Object)connection.getConnectionId())) {
            this.cache.remove(connection.getConnectionId());
            try {
                connection.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close connection", (Throwable)e);
            }
        }
    }
}

