/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.salesforce.springboot;

import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.component.salesforce.AuthenticationType;
import org.apache.camel.component.salesforce.NotFoundBehaviour;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.component.salesforce.api.dto.approval.ApprovalRequest;
import org.apache.camel.component.salesforce.api.dto.approval.ApprovalRequest.Action;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.dto.NotifyForFieldsEnum;
import org.apache.camel.component.salesforce.internal.dto.NotifyForOperationsEnum;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.apache.camel.util.jsse.KeyStoreParameters;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The salesforce component is used for integrating Camel with the massive
 * Salesforce API.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.salesforce")
public class SalesforceComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the salesforce component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Explicit authentication method to be used, one of USERNAME_PASSWORD,
     * REFRESH_TOKEN or JWT. Salesforce component can auto-determine the
     * authentication method to use from the properties set, set this property
     * to eliminate any ambiguity.
     */
    private AuthenticationType authenticationType;
    /**
     * All authentication configuration in one nested bean, all properties set
     * there can be set directly on the component as well
     */
    private SalesforceLoginConfigNestedConfiguration loginConfig;
    /**
     * URL of the Salesforce instance used after authantication, by default
     * received from Salesforce on successful authentication
     */
    private String instanceUrl;
    /**
     * URL of the Salesforce instance used for authentication, by default set to
     * https://login.salesforce.com
     */
    private String loginUrl = "https://login.salesforce.com";
    /**
     * OAuth Consumer Key of the connected app configured in the Salesforce
     * instance setup. Typically a connected app needs to be configured but one
     * can be provided by installing a package.
     */
    private String clientId;
    /**
     * OAuth Consumer Secret of the connected app configured in the Salesforce
     * instance setup.
     */
    private String clientSecret;
    /**
     * KeyStore parameters to use in OAuth JWT flow. The KeyStore should contain
     * only one entry with private key and certificate. Salesforce does not
     * verify the certificate chain, so this can easily be a selfsigned
     * certificate. Make sure that you upload the certificate to the
     * corresponding connected app. The option is a
     * org.apache.camel.util.jsse.KeyStoreParameters type.
     */
    private String keystore;
    /**
     * Refresh token already obtained in the refresh token OAuth flow. One needs
     * to setup a web application and configure a callback URL to receive the
     * refresh token, or configure using the builtin callback at
     * https://login.salesforce.com/services/oauth2/success or
     * https://test.salesforce.com/services/oauth2/success and then retrive the
     * refresh_token from the URL at the end of the flow. Note that in
     * development organizations Salesforce allows hosting the callback web
     * application at localhost.
     */
    private String refreshToken;
    /**
     * Username used in OAuth flow to gain access to access token. It's easy to
     * get started with password OAuth flow, but in general one should avoid it
     * as it is deemed less secure than other flows.
     */
    private String userName;
    /**
     * Password used in OAuth flow to gain access to access token. It's easy to
     * get started with password OAuth flow, but in general one should avoid it
     * as it is deemed less secure than other flows. Make sure that you append
     * security token to the end of the password if using one.
     */
    private String password;
    /**
     * If set to true prevents the component from authenticating to Salesforce
     * with the start of the component. You would generaly set this to the
     * (default) false and authenticate early and be immediately aware of any
     * authentication issues.
     */
    private Boolean lazyLogin = false;
    /**
     * Global endpoint configuration - use to set values that are common to all
     * endpoints
     */
    private SalesforceEndpointConfigNestedConfiguration config;
    /**
     * Used to set any properties that can be configured on the underlying HTTP
     * client. Have a look at properties of SalesforceHttpClient and the Jetty
     * HttpClient for all available options. The option is a
     * java.util.Map<java.lang.String,java.lang.Object> type.
     */
    private String httpClientProperties;
    /**
     * Used to set any properties that can be configured on the
     * LongPollingTransport used by the BayeuxClient (CometD) used by the
     * streaming api. The option is a
     * java.util.Map<java.lang.String,java.lang.Object> type.
     */
    private String longPollingTransportProperties;
    /**
     * SSL parameters to use, see SSLContextParameters class for all available
     * options. The option is a org.apache.camel.util.jsse.SSLContextParameters
     * type.
     */
    private String sslContextParameters;
    /**
     * Enable usage of global SSL context parameters
     */
    private Boolean useGlobalSslContextParameters = false;
    /**
     * Hostname of the HTTP proxy server to use.
     */
    private String httpProxyHost;
    /**
     * Port number of the HTTP proxy server to use.
     */
    private Integer httpProxyPort;
    /**
     * Username to use to authenticate against the HTTP proxy server.
     */
    private String httpProxyUsername;
    /**
     * Password to use to authenticate against the HTTP proxy server.
     */
    private String httpProxyPassword;
    /**
     * If set to true the configures the HTTP proxy to use as a SOCKS4 proxy.
     */
    private Boolean isHttpProxySocks4 = false;
    /**
     * If set to false disables the use of TLS when accessing the HTTP proxy.
     */
    private Boolean isHttpProxySecure = true;
    /**
     * A list of addresses for which HTTP proxy server should be used. The
     * option is a java.util.Set<java.lang.String> type.
     */
    private String httpProxyIncludedAddresses;
    /**
     * A list of addresses for which HTTP proxy server should not be used. The
     * option is a java.util.Set<java.lang.String> type.
     */
    private String httpProxyExcludedAddresses;
    /**
     * Used in authentication against the HTTP proxy server, needs to match the
     * URI of the proxy server in order for the httpProxyUsername and
     * httpProxyPassword to be used for authentication.
     */
    private String httpProxyAuthUri;
    /**
     * Realm of the proxy server, used in preemptive Basic/Digest authentication
     * methods against the HTTP proxy server.
     */
    private String httpProxyRealm;
    /**
     * If set to true Digest authentication will be used when authenticating to
     * the HTTP proxy,otherwise Basic authorization method will be used
     */
    private Boolean httpProxyUseDigestAuth = false;
    /**
     * In what packages are the generated DTO classes. Typically the classes
     * would be generated using camel-salesforce-maven-plugin. Set it if using
     * the generated DTOs to gain the benefit of using short SObject names in
     * parameters/header values.
     */
    private String[] packages;
    /**
     * Whether the component should resolve property placeholders on itself when
     * starting. Only properties which are of String type can use property
     * placeholders.
     */
    private Boolean resolvePropertyPlaceholders = true;

    public AuthenticationType getAuthenticationType() {
        return authenticationType;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    public SalesforceLoginConfigNestedConfiguration getLoginConfig() {
        return loginConfig;
    }

    public void setLoginConfig(
            SalesforceLoginConfigNestedConfiguration loginConfig) {
        this.loginConfig = loginConfig;
    }

    public String getInstanceUrl() {
        return instanceUrl;
    }

    public void setInstanceUrl(String instanceUrl) {
        this.instanceUrl = instanceUrl;
    }

    public String getLoginUrl() {
        return loginUrl;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getKeystore() {
        return keystore;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public String getRefreshToken() {
        return refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getLazyLogin() {
        return lazyLogin;
    }

    public void setLazyLogin(Boolean lazyLogin) {
        this.lazyLogin = lazyLogin;
    }

    public SalesforceEndpointConfigNestedConfiguration getConfig() {
        return config;
    }

    public void setConfig(SalesforceEndpointConfigNestedConfiguration config) {
        this.config = config;
    }

    public String getHttpClientProperties() {
        return httpClientProperties;
    }

    public void setHttpClientProperties(String httpClientProperties) {
        this.httpClientProperties = httpClientProperties;
    }

    public String getLongPollingTransportProperties() {
        return longPollingTransportProperties;
    }

    public void setLongPollingTransportProperties(
            String longPollingTransportProperties) {
        this.longPollingTransportProperties = longPollingTransportProperties;
    }

    public String getSslContextParameters() {
        return sslContextParameters;
    }

    public void setSslContextParameters(String sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getUseGlobalSslContextParameters() {
        return useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(
            Boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }

    public String getHttpProxyHost() {
        return httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public Boolean getIsHttpProxySocks4() {
        return isHttpProxySocks4;
    }

    public void setIsHttpProxySocks4(Boolean isHttpProxySocks4) {
        this.isHttpProxySocks4 = isHttpProxySocks4;
    }

    public Boolean getIsHttpProxySecure() {
        return isHttpProxySecure;
    }

    public void setIsHttpProxySecure(Boolean isHttpProxySecure) {
        this.isHttpProxySecure = isHttpProxySecure;
    }

    public String getHttpProxyIncludedAddresses() {
        return httpProxyIncludedAddresses;
    }

    public void setHttpProxyIncludedAddresses(String httpProxyIncludedAddresses) {
        this.httpProxyIncludedAddresses = httpProxyIncludedAddresses;
    }

    public String getHttpProxyExcludedAddresses() {
        return httpProxyExcludedAddresses;
    }

    public void setHttpProxyExcludedAddresses(String httpProxyExcludedAddresses) {
        this.httpProxyExcludedAddresses = httpProxyExcludedAddresses;
    }

    public String getHttpProxyAuthUri() {
        return httpProxyAuthUri;
    }

    public void setHttpProxyAuthUri(String httpProxyAuthUri) {
        this.httpProxyAuthUri = httpProxyAuthUri;
    }

    public String getHttpProxyRealm() {
        return httpProxyRealm;
    }

    public void setHttpProxyRealm(String httpProxyRealm) {
        this.httpProxyRealm = httpProxyRealm;
    }

    public Boolean getHttpProxyUseDigestAuth() {
        return httpProxyUseDigestAuth;
    }

    public void setHttpProxyUseDigestAuth(Boolean httpProxyUseDigestAuth) {
        this.httpProxyUseDigestAuth = httpProxyUseDigestAuth;
    }

    public String[] getPackages() {
        return packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(
            Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public static class SalesforceLoginConfigNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.salesforce.SalesforceLoginConfig.class;
        private String instanceUrl;
        /**
         * Salesforce login URL, defaults to https://login.salesforce.com
         */
        private String loginUrl;
        /**
         * Salesforce connected application Consumer Key
         */
        private String clientId;
        /**
         * Salesforce connected application Consumer Secret
         */
        private String clientSecret;
        /**
         * Keystore parameters for keystore containing certificate and private
         * key needed for OAuth 2.0 JWT Bearer Token Flow.
         */
        private KeyStoreParameters keystore;
        /**
         * Salesforce connected application Consumer token
         */
        private String refreshToken;
        private AuthenticationType type;
        /**
         * Salesforce account user name
         */
        private String userName;
        /**
         * Salesforce account password
         */
        private String password;
        /**
         * Flag to enable/disable lazy OAuth, default is false. When enabled,
         * OAuth token retrieval or generation is not done until the first API
         * call
         */
        private Boolean lazyLogin;

        public String getInstanceUrl() {
            return instanceUrl;
        }

        public void setInstanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
        }

        public String getLoginUrl() {
            return loginUrl;
        }

        public void setLoginUrl(String loginUrl) {
            this.loginUrl = loginUrl;
        }

        public String getClientId() {
            return clientId;
        }

        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public String getClientSecret() {
            return clientSecret;
        }

        public void setClientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
        }

        public KeyStoreParameters getKeystore() {
            return keystore;
        }

        public void setKeystore(KeyStoreParameters keystore) {
            this.keystore = keystore;
        }

        public String getRefreshToken() {
            return refreshToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public AuthenticationType getType() {
            return type;
        }

        public void setType(AuthenticationType type) {
            this.type = type;
        }

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public Boolean getLazyLogin() {
            return lazyLogin;
        }

        public void setLazyLogin(Boolean lazyLogin) {
            this.lazyLogin = lazyLogin;
        }
    }

    public static class SalesforceEndpointConfigNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.salesforce.SalesforceEndpointConfig.class;
        /**
         * Payload format to use for Salesforce API calls, either JSON or XML,
         * defaults to JSON
         */
        private PayloadFormat format;
        /**
         * Use raw payload String for request and response (either JSON or XML
         * depending on format), instead of DTOs, false by default
         */
        private Boolean rawPayload = false;
        /**
         * Salesforce API version, defaults to
         * SalesforceEndpointConfig.DEFAULT_VERSION
         */
        private String apiVersion;
        /**
         * SObject name if required or supported by API
         */
        private String sObjectName;
        /**
         * SObject ID if required by API
         */
        private String sObjectId;
        /**
         * SObject fields to retrieve
         */
        private String sObjectFields;
        /**
         * SObject external ID field name
         */
        private String sObjectIdName;
        /**
         * SObject external ID field value
         */
        private String sObjectIdValue;
        /**
         * SObject blob field name
         */
        private String sObjectBlobFieldName;
        /**
         * Fully qualified SObject class name, usually generated using
         * camel-salesforce-maven-plugin
         */
        private String sObjectClass;
        /**
         * Salesforce SOQL query string
         */
        private String sObjectQuery;
        /**
         * Salesforce SOSL search string
         */
        private String sObjectSearch;
        /**
         * Should the NULL values of given DTO be serialized with empty (NULL)
         * values. This affects only JSON data format.
         */
        private Boolean serializeNulls = false;
        /**
         * APEX method name
         */
        private String apexMethod;
        /**
         * APEX method URL
         */
        private String apexUrl;
        /**
         * Query params for APEX method
         */
        private Map apexQueryParams;
        /**
         * The approval request for Approval API.
         * 
         * @param approval
         */
        private ApprovalRequest approval;
        /**
         * Bulk API content type, one of XML, CSV, ZIP_XML, ZIP_CSV
         */
        private ContentType contentType;
        /**
         * Bulk API Job ID
         */
        private String jobId;
        /**
         * Bulk API Batch ID
         */
        private String batchId;
        /**
         * Bulk API Result ID
         */
        private String resultId;
        /**
         * Whether to update an existing Push Topic when using the Streaming
         * API, defaults to false
         */
        private Boolean updateTopic = false;
        /**
         * Notify for fields, options are ALL, REFERENCED, SELECT, WHERE
         */
        private NotifyForFieldsEnum notifyForFields;
        /**
         * Notify for operations, options are ALL, CREATE, EXTENDED, UPDATE (API
         * version 29.0)
         */
        private NotifyForOperationsEnum notifyForOperations;
        /**
         * Notify for create operation, defaults to false (API version = 29.0)
         */
        private Boolean notifyForOperationCreate;
        /**
         * Notify for update operation, defaults to false (API version = 29.0)
         */
        private Boolean notifyForOperationUpdate;
        /**
         * Notify for delete operation, defaults to false (API version = 29.0)
         */
        private Boolean notifyForOperationDelete;
        /**
         * Notify for un-delete operation, defaults to false (API version =
         * 29.0)
         */
        private Boolean notifyForOperationUndelete;
        /**
         * Salesforce1 Analytics report Id
         */
        private String reportId;
        /**
         * Include details in Salesforce1 Analytics report, defaults to false.
         */
        private Boolean includeDetails;
        /**
         * Salesforce1 Analytics report metadata for filtering
         */
        private ReportMetadata reportMetadata;
        /**
         * Salesforce1 Analytics report execution instance ID
         */
        private String instanceId;
        /**
         * Custom Jetty Http Client to use to connect to Salesforce.
         */
        private SalesforceHttpClient httpClient;
        /**
         * Custom Jackson ObjectMapper to use when serializing/deserializing
         * Salesforce objects.
         */
        private ObjectMapper objectMapper;
        /**
         * Backoff interval increment for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         */
        private Long backoffIncrement;
        /**
         * Maximum backoff interval for Streaming connection restart attempts
         * for failures beyond CometD auto-reconnect.
         */
        private Long maxBackoff;
        /**
         * Default replayId setting if no value is found in initialReplayIdMap
         */
        private Long defaultReplayId;
        /**
         * Replay IDs to start from per channel name.
         */
        private Map initialReplayIdMap;
        /**
         * Limit on number of returned records. Applicable to some of the API,
         * check the Salesforce documentation.
         */
        private Integer limit;
        /**
         * Represents the kind of action to take: Submit, Approve, or Reject.
         * 
         * @param actionType
         */
        private Action approvalActionType;
        /**
         * The comment to add to the history step associated with this request.
         * 
         * @param comments
         */
        private String approvalComments;
        /**
         * The ID of the submitter who?s requesting the approval record.
         * 
         * @param contextActorId
         */
        private String approvalContextActorId;
        /**
         * The ID of the item that is being acted upon.
         * 
         * @param contextId
         */
        private String approvalContextId;
        /**
         * If the process requires specification of the next approval, the ID of
         * the user to be assigned the next request.
         * 
         * @param nextApproverIds
         */
        private List approvalNextApproverIds;
        /**
         * The developer name or ID of the process definition.
         * 
         * @param processDefinitionNameOrId
         */
        private String approvalProcessDefinitionNameOrId;
        /**
         * Determines whether to evaluate the entry criteria for the process
         * (true) or not (false) if the process definition name or ID isn?t
         * null. If the process definition name or ID isn?t specified, this
         * argument is ignored, and standard evaluation is followed based on
         * process order. By default, the entry criteria isn?t skipped if it?s
         * not set by this request.
         * 
         * @param skipEntryCriteria
         */
        private Boolean approvalSkipEntryCriteria;
        /**
         * Sets the behaviour of 404 not found status received from Salesforce
         * API. Should the body be set to NULL NotFoundBehaviour#NULL or should
         * a exception be signaled on the exchange NotFoundBehaviour#EXCEPTION -
         * the default.
         */
        private NotFoundBehaviour notFoundBehaviour;

        public PayloadFormat getFormat() {
            return format;
        }

        public void setFormat(PayloadFormat format) {
            this.format = format;
        }

        public Boolean getRawPayload() {
            return rawPayload;
        }

        public void setRawPayload(Boolean rawPayload) {
            this.rawPayload = rawPayload;
        }

        public String getApiVersion() {
            return apiVersion;
        }

        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        public String getSObjectName() {
            return sObjectName;
        }

        public void setSObjectName(String sObjectName) {
            this.sObjectName = sObjectName;
        }

        public String getSObjectId() {
            return sObjectId;
        }

        public void setSObjectId(String sObjectId) {
            this.sObjectId = sObjectId;
        }

        public String getSObjectFields() {
            return sObjectFields;
        }

        public void setSObjectFields(String sObjectFields) {
            this.sObjectFields = sObjectFields;
        }

        public String getSObjectIdName() {
            return sObjectIdName;
        }

        public void setSObjectIdName(String sObjectIdName) {
            this.sObjectIdName = sObjectIdName;
        }

        public String getSObjectIdValue() {
            return sObjectIdValue;
        }

        public void setSObjectIdValue(String sObjectIdValue) {
            this.sObjectIdValue = sObjectIdValue;
        }

        public String getSObjectBlobFieldName() {
            return sObjectBlobFieldName;
        }

        public void setSObjectBlobFieldName(String sObjectBlobFieldName) {
            this.sObjectBlobFieldName = sObjectBlobFieldName;
        }

        public String getSObjectClass() {
            return sObjectClass;
        }

        public void setSObjectClass(String sObjectClass) {
            this.sObjectClass = sObjectClass;
        }

        public String getSObjectQuery() {
            return sObjectQuery;
        }

        public void setSObjectQuery(String sObjectQuery) {
            this.sObjectQuery = sObjectQuery;
        }

        public String getSObjectSearch() {
            return sObjectSearch;
        }

        public void setSObjectSearch(String sObjectSearch) {
            this.sObjectSearch = sObjectSearch;
        }

        public Boolean getSerializeNulls() {
            return serializeNulls;
        }

        public void setSerializeNulls(Boolean serializeNulls) {
            this.serializeNulls = serializeNulls;
        }

        public String getApexMethod() {
            return apexMethod;
        }

        public void setApexMethod(String apexMethod) {
            this.apexMethod = apexMethod;
        }

        public String getApexUrl() {
            return apexUrl;
        }

        public void setApexUrl(String apexUrl) {
            this.apexUrl = apexUrl;
        }

        public Map getApexQueryParams() {
            return apexQueryParams;
        }

        public void setApexQueryParams(Map apexQueryParams) {
            this.apexQueryParams = apexQueryParams;
        }

        public ApprovalRequest getApproval() {
            return approval;
        }

        public void setApproval(ApprovalRequest approval) {
            this.approval = approval;
        }

        public ContentType getContentType() {
            return contentType;
        }

        public void setContentType(ContentType contentType) {
            this.contentType = contentType;
        }

        public String getJobId() {
            return jobId;
        }

        public void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public String getBatchId() {
            return batchId;
        }

        public void setBatchId(String batchId) {
            this.batchId = batchId;
        }

        public String getResultId() {
            return resultId;
        }

        public void setResultId(String resultId) {
            this.resultId = resultId;
        }

        public Boolean getUpdateTopic() {
            return updateTopic;
        }

        public void setUpdateTopic(Boolean updateTopic) {
            this.updateTopic = updateTopic;
        }

        public NotifyForFieldsEnum getNotifyForFields() {
            return notifyForFields;
        }

        public void setNotifyForFields(NotifyForFieldsEnum notifyForFields) {
            this.notifyForFields = notifyForFields;
        }

        public NotifyForOperationsEnum getNotifyForOperations() {
            return notifyForOperations;
        }

        public void setNotifyForOperations(
                NotifyForOperationsEnum notifyForOperations) {
            this.notifyForOperations = notifyForOperations;
        }

        public Boolean getNotifyForOperationCreate() {
            return notifyForOperationCreate;
        }

        public void setNotifyForOperationCreate(Boolean notifyForOperationCreate) {
            this.notifyForOperationCreate = notifyForOperationCreate;
        }

        public Boolean getNotifyForOperationUpdate() {
            return notifyForOperationUpdate;
        }

        public void setNotifyForOperationUpdate(Boolean notifyForOperationUpdate) {
            this.notifyForOperationUpdate = notifyForOperationUpdate;
        }

        public Boolean getNotifyForOperationDelete() {
            return notifyForOperationDelete;
        }

        public void setNotifyForOperationDelete(Boolean notifyForOperationDelete) {
            this.notifyForOperationDelete = notifyForOperationDelete;
        }

        public Boolean getNotifyForOperationUndelete() {
            return notifyForOperationUndelete;
        }

        public void setNotifyForOperationUndelete(
                Boolean notifyForOperationUndelete) {
            this.notifyForOperationUndelete = notifyForOperationUndelete;
        }

        public String getReportId() {
            return reportId;
        }

        public void setReportId(String reportId) {
            this.reportId = reportId;
        }

        public Boolean getIncludeDetails() {
            return includeDetails;
        }

        public void setIncludeDetails(Boolean includeDetails) {
            this.includeDetails = includeDetails;
        }

        public ReportMetadata getReportMetadata() {
            return reportMetadata;
        }

        public void setReportMetadata(ReportMetadata reportMetadata) {
            this.reportMetadata = reportMetadata;
        }

        public String getInstanceId() {
            return instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public SalesforceHttpClient getHttpClient() {
            return httpClient;
        }

        public void setHttpClient(SalesforceHttpClient httpClient) {
            this.httpClient = httpClient;
        }

        public ObjectMapper getObjectMapper() {
            return objectMapper;
        }

        public void setObjectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        public Long getBackoffIncrement() {
            return backoffIncrement;
        }

        public void setBackoffIncrement(Long backoffIncrement) {
            this.backoffIncrement = backoffIncrement;
        }

        public Long getMaxBackoff() {
            return maxBackoff;
        }

        public void setMaxBackoff(Long maxBackoff) {
            this.maxBackoff = maxBackoff;
        }

        public Long getDefaultReplayId() {
            return defaultReplayId;
        }

        public void setDefaultReplayId(Long defaultReplayId) {
            this.defaultReplayId = defaultReplayId;
        }

        public Map getInitialReplayIdMap() {
            return initialReplayIdMap;
        }

        public void setInitialReplayIdMap(Map initialReplayIdMap) {
            this.initialReplayIdMap = initialReplayIdMap;
        }

        public Integer getLimit() {
            return limit;
        }

        public void setLimit(Integer limit) {
            this.limit = limit;
        }

        public Action getApprovalActionType() {
            return approvalActionType;
        }

        public void setApprovalActionType(Action approvalActionType) {
            this.approvalActionType = approvalActionType;
        }

        public String getApprovalComments() {
            return approvalComments;
        }

        public void setApprovalComments(String approvalComments) {
            this.approvalComments = approvalComments;
        }

        public String getApprovalContextActorId() {
            return approvalContextActorId;
        }

        public void setApprovalContextActorId(String approvalContextActorId) {
            this.approvalContextActorId = approvalContextActorId;
        }

        public String getApprovalContextId() {
            return approvalContextId;
        }

        public void setApprovalContextId(String approvalContextId) {
            this.approvalContextId = approvalContextId;
        }

        public List getApprovalNextApproverIds() {
            return approvalNextApproverIds;
        }

        public void setApprovalNextApproverIds(List approvalNextApproverIds) {
            this.approvalNextApproverIds = approvalNextApproverIds;
        }

        public String getApprovalProcessDefinitionNameOrId() {
            return approvalProcessDefinitionNameOrId;
        }

        public void setApprovalProcessDefinitionNameOrId(
                String approvalProcessDefinitionNameOrId) {
            this.approvalProcessDefinitionNameOrId = approvalProcessDefinitionNameOrId;
        }

        public Boolean getApprovalSkipEntryCriteria() {
            return approvalSkipEntryCriteria;
        }

        public void setApprovalSkipEntryCriteria(
                Boolean approvalSkipEntryCriteria) {
            this.approvalSkipEntryCriteria = approvalSkipEntryCriteria;
        }

        public NotFoundBehaviour getNotFoundBehaviour() {
            return notFoundBehaviour;
        }

        public void setNotFoundBehaviour(NotFoundBehaviour notFoundBehaviour) {
            this.notFoundBehaviour = notFoundBehaviour;
        }
    }
}