/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.component.service.ServiceEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.cloud.ServiceRegistryHelper;
import org.apache.camel.impl.cloud.ServiceRegistrySelectors;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class ServiceComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private ServiceRegistry service;
    @Metadata(label="advanced")
    private ServiceRegistry.Selector serviceSelector = ServiceRegistrySelectors.DEFAULT_SELECTOR;

    public ServiceComponent() {
        this(null);
    }

    public ServiceComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String serviceName = StringHelper.before((String)remaining, (String)":");
        String delegateUri = StringHelper.after((String)remaining, (String)":");
        ObjectHelper.notNull((Object)serviceName, (String)"Service Name");
        ObjectHelper.notNull((Object)delegateUri, (String)"Delegate URI");
        ServiceRegistry service = this.getServiceRegistry();
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            if (!entry.getKey().startsWith("service.")) continue;
            String key = entry.getKey();
            String val = (String)this.getCamelContext().getTypeConverter().convertTo(String.class, entry.getValue());
            params.put(key, val);
        }
        params.put("service.name", serviceName);
        parameters.keySet().removeAll(parameters.keySet());
        return new ServiceEndpoint(uri, this, service, params, URISupport.appendParametersToURI((String)delegateUri, parameters));
    }

    public ServiceRegistry getService() {
        return this.service;
    }

    public void setService(ServiceRegistry service) {
        this.service = service;
    }

    public ServiceRegistry.Selector getServiceSelector() {
        return this.serviceSelector;
    }

    public void setServiceSelector(ServiceRegistry.Selector serviceSelector) {
        this.serviceSelector = serviceSelector;
    }

    private ServiceRegistry getServiceRegistry() {
        if (this.service == null) {
            return (ServiceRegistry)ServiceRegistryHelper.lookupService((CamelContext)this.getCamelContext(), (ServiceRegistry.Selector)this.serviceSelector).orElseThrow(() -> new IllegalStateException("No cluster service found"));
        }
        return this.service;
    }
}

