/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.as2;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.component.as2.internal.AS2ApiName;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.http.entity.ContentType;

@UriParams
public class AS2Configuration {
    @UriPath
    @Metadata(required="true")
    private AS2ApiName apiName;
    @UriParam
    @Metadata(required="true")
    private String methodName;
    @UriParam(defaultValue="1.1", enums="1.0,1.1")
    private String as2Version = "1.1";
    @UriParam(defaultValue="Camel AS2 Client Endpoint")
    private String userAgent = "Camel AS2 Client Endpoint";
    @UriParam(defaultValue="Camel AS2 Server Endpoint")
    private String server = "Camel AS2 Server Endpoint";
    @UriParam(defaultValue="camel.apache.org")
    private String serverFqdn = "camel.apache.org";
    @UriParam
    private String targetHostname;
    @UriParam
    private Integer targetPortNumber;
    @UriParam(defaultValue="camel.apache.org")
    private String clientFqdn = "camel.apache.org";
    @UriParam
    private Integer serverPortNumber;
    @UriParam(defaultValue="/")
    private String requestUri = "/";
    @UriParam
    private ContentType ediMessageType;
    @UriParam
    private String ediMessageTransferEncoding;
    @UriParam
    private AS2MessageStructure as2MessageStructure;
    @UriParam
    private String subject;
    @UriParam
    private String from;
    @UriParam
    private String as2From;
    @UriParam
    private String as2To;
    @UriParam
    private AS2SignatureAlgorithm signingAlgorithm;
    @UriParam
    private Certificate[] signingCertificateChain;
    @UriParam
    private PrivateKey signingPrivateKey;
    @UriParam
    private String dispositionNotificationTo;
    @UriParam
    private String[] signedReceiptMicAlgorithms;
    @UriParam
    private AS2EncryptionAlgorithm encryptingAlgorithm;
    @UriParam
    private Certificate[] encryptingCertificateChain;
    @UriParam
    private PrivateKey encryptingPrivateKey;

    public AS2ApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(AS2ApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getAs2Version() {
        return this.as2Version;
    }

    public void setAs2Version(String as2Version) {
        if (!as2Version.equals("1.0") && !as2Version.equals("1.1")) {
            throw new IllegalArgumentException(String.format("Value '%s' of configuration parameter 'as2Version' must be either '1.0' or '1.1'", as2Version));
        }
        this.as2Version = as2Version;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getServerFqdn() {
        return this.serverFqdn;
    }

    public void setServerFqdn(String serverFqdn) {
        if (this.clientFqdn == null) {
            throw new RuntimeCamelException("Parameter 'serverFqdn' can not be null");
        }
        this.serverFqdn = serverFqdn;
    }

    public String getTargetHostname() {
        return this.targetHostname;
    }

    public void setTargetHostname(String targetHostname) {
        this.targetHostname = targetHostname;
    }

    public int getTargetPortNumber() {
        return this.targetPortNumber;
    }

    public void setTargetPortNumber(String targetPortNumber) {
        try {
            this.targetPortNumber = Integer.valueOf(targetPortNumber);
        }
        catch (NumberFormatException e) {
            throw new RuntimeCamelException(String.format("Invalid target port number: %s", targetPortNumber));
        }
    }

    public void setTargetPortNumber(Integer targetPortNumber) {
        this.targetPortNumber = targetPortNumber;
    }

    public String getClientFqdn() {
        return this.clientFqdn;
    }

    public void setClientFqdn(String clientFqdn) {
        if (clientFqdn == null) {
            throw new RuntimeCamelException("Parameter 'clientFqdn' can not be null");
        }
        this.clientFqdn = clientFqdn;
    }

    public Integer getServerPortNumber() {
        return this.serverPortNumber;
    }

    public void setServerPortNumber(String serverPortNumber) {
        try {
            this.serverPortNumber = Integer.valueOf(serverPortNumber);
        }
        catch (NumberFormatException e) {
            throw new RuntimeCamelException(String.format("Invalid target port number: %s", this.targetPortNumber));
        }
    }

    public void setServerPortNumber(Integer serverPortNumber) {
        this.serverPortNumber = serverPortNumber;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public ContentType getEdiMessageType() {
        return this.ediMessageType;
    }

    public void setEdiMessageType(ContentType ediMessageType) {
        this.ediMessageType = ediMessageType;
    }

    public String getEdiMessageTransferEncoding() {
        return this.ediMessageTransferEncoding;
    }

    public void setEdiMessageTransferEncoding(String ediMessageTransferEncoding) {
        this.ediMessageTransferEncoding = ediMessageTransferEncoding;
    }

    public AS2MessageStructure getAs2MessageStructure() {
        return this.as2MessageStructure;
    }

    public void setAs2MessageStructure(AS2MessageStructure as2MessageStructure) {
        this.as2MessageStructure = as2MessageStructure;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getAs2From() {
        return this.as2From;
    }

    public void setAs2From(String as2From) {
        this.as2From = as2From;
    }

    public String getAs2To() {
        return this.as2To;
    }

    public void setAs2To(String as2To) {
        this.as2To = as2To;
    }

    public AS2SignatureAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public void setSigningAlgorithm(AS2SignatureAlgorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
    }

    public Certificate[] getSigningCertificateChain() {
        return this.signingCertificateChain;
    }

    public void setSigningCertificateChain(Certificate[] signingCertificateChain) {
        this.signingCertificateChain = signingCertificateChain;
    }

    public PrivateKey getSigningPrivateKey() {
        return this.signingPrivateKey;
    }

    public void setSigningPrivateKey(PrivateKey signingPrivateKey) {
        this.signingPrivateKey = signingPrivateKey;
    }

    public String getDispositionNotificationTo() {
        return this.dispositionNotificationTo;
    }

    public void setDispositionNotificationTo(String dispositionNotificationTo) {
        this.dispositionNotificationTo = dispositionNotificationTo;
    }

    public String[] getSignedReceiptMicAlgorithms() {
        return this.signedReceiptMicAlgorithms;
    }

    public void setSignedReceiptMicAlgorithms(String[] signedReceiptMicAlgorithms) {
        this.signedReceiptMicAlgorithms = signedReceiptMicAlgorithms;
    }

    public AS2EncryptionAlgorithm getEncryptingingAlgorithm() {
        return this.encryptingAlgorithm;
    }

    public void setEncryptingAlgorithm(AS2EncryptionAlgorithm encryptingAlgorithm) {
        this.encryptingAlgorithm = encryptingAlgorithm;
    }

    public Certificate[] getEncryptingCertificateChain() {
        return this.encryptingCertificateChain;
    }

    public void setEncryptingCertificateChain(Certificate[] signingCertificateChain) {
        this.encryptingCertificateChain = signingCertificateChain;
    }

    public PrivateKey getEncryptingPrivateKey() {
        return this.encryptingPrivateKey;
    }

    public void setEncryptingPrivateKey(PrivateKey signingPrivateKey) {
        this.encryptingPrivateKey = signingPrivateKey;
    }
}

