/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ipfs;

import io.nessus.ipfs.IPFSClient;
import io.nessus.ipfs.impl.DefaultIPFSClient;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.ipfs.IPFSConfiguration;
import org.apache.camel.component.ipfs.IPFSEndpoint;
import org.apache.camel.impl.DefaultComponent;

public class IPFSComponent
extends DefaultComponent {
    private IPFSClient client;

    protected Endpoint createEndpoint(String urispec, String remaining, Map<String, Object> params) throws Exception {
        IPFSConfiguration config = new IPFSConfiguration(this);
        this.setProperties(config, params);
        URI uri = new URI(urispec);
        String host = uri.getHost();
        int port = uri.getPort();
        String cmd = remaining;
        if (!cmd.equals(host)) {
            if (host != null) {
                config.setIpfsHost(host);
            }
            if (port > 0) {
                config.setIpfsPort(port);
            }
            int idx = cmd.indexOf(47);
            cmd = cmd.substring(idx + 1);
        }
        config.setIpfsCmd(cmd);
        this.client = this.createClient(config);
        return new IPFSEndpoint(urispec, this, config);
    }

    public IPFSClient getIPFSClient() {
        return this.client;
    }

    private synchronized IPFSClient createClient(IPFSConfiguration config) {
        return new DefaultIPFSClient(config.getIpfsHost(), Integer.valueOf(config.getIpfsPort()));
    }
}

