/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.server;

import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.jbpm.services.api.service.ServiceRegistry;
import org.kie.server.services.api.KieContainerInstance;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelKieServerExtension
implements KieServerExtension {
    public static final String EXTENSION_NAME = "Camel";
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelKieServerExtension.class);
    private static final Boolean DISABLED = Boolean.parseBoolean(System.getProperty("org.camel.server.ext.disabled", "false"));
    protected DefaultCamelContext camel;
    protected boolean managedCamel;
    protected Map<String, DefaultCamelContext> camelContexts = new HashMap<String, DefaultCamelContext>();

    public CamelKieServerExtension() {
        this.managedCamel = true;
    }

    public CamelKieServerExtension(DefaultCamelContext camel) {
        this.camel = camel;
        this.managedCamel = false;
    }

    public boolean isInitialized() {
        return this.camel != null;
    }

    public boolean isActive() {
        return DISABLED == false;
    }

    public void init(KieServerImpl kieServer, KieServerRegistry registry) {
        if (this.managedCamel && this.camel == null) {
            this.camel = new DefaultCamelContext();
            this.camel.setName("KIE Server Camel context");
            try (InputStream is = this.getClass().getResourceAsStream("/global-camel-routes.xml");){
                if (is != null) {
                    RoutesDefinition routes = this.camel.loadRoutesDefinition(is);
                    this.camel.addRouteDefinitions((Collection)routes.getRoutes());
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while adding Camel context for KIE Server", (Throwable)e);
            }
        }
        ServiceRegistry.get().register("GlobalCamelService", (Object)this.camel);
    }

    public void destroy(KieServerImpl kieServer, KieServerRegistry registry) {
        ServiceRegistry.get().remove("GlobalCamelService");
        if (this.managedCamel && this.camel != null) {
            try {
                this.camel.stop();
            }
            catch (Exception e) {
                LOGGER.error("Failed at stopping KIE Server extension {}", (Object)EXTENSION_NAME);
            }
        }
    }

    public void createContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        ClassLoader classloader = kieContainerInstance.getKieContainer().getClassLoader();
        try (InputStream is = classloader.getResourceAsStream("camel-routes.xml");){
            if (is != null) {
                DefaultCamelContext context = new DefaultCamelContext();
                context.setName("KIE Server Camel context for container " + kieContainerInstance.getContainerId());
                RoutesDefinition routes = context.loadRoutesDefinition(is);
                this.annotateKJarRoutes(routes, id);
                context.addRouteDefinitions((Collection)routes.getRoutes());
                context.start();
                this.camelContexts.put(id, context);
                ServiceRegistry.get().register(id + "_CamelService", (Object)this.camel);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while adding Camel context for {}", (Object)kieContainerInstance.getContainerId(), (Object)e);
        }
    }

    public void updateContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        this.disposeContainer(id, kieContainerInstance, parameters);
        this.createContainer(id, kieContainerInstance, parameters);
    }

    public boolean isUpdateContainerAllowed(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        return true;
    }

    public void disposeContainer(String id, KieContainerInstance kieContainerInstance, Map<String, Object> parameters) {
        DefaultCamelContext context = this.camelContexts.get(id);
        if (context != null) {
            ServiceRegistry.get().remove(id + "_CamelService");
            try {
                context.stop();
            }
            catch (Exception e) {
                LOGGER.error("Error while removing Camel context for container {}", (Object)id, (Object)e);
            }
        }
    }

    public List<Object> getAppComponents(SupportedTransports type) {
        return Collections.emptyList();
    }

    public <T> T getAppComponents(Class<T> serviceType) {
        return null;
    }

    public String getImplementedCapability() {
        return "Integration";
    }

    public List<Object> getServices() {
        return Collections.emptyList();
    }

    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public Integer getStartOrder() {
        return 50;
    }

    public void serverStarted() {
        if (this.managedCamel && this.camel != null && !this.camel.isStarted()) {
            try {
                this.camel.start();
            }
            catch (Exception e) {
                LOGGER.error("Failed at start Camel context", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "Camel KIE Server extension";
    }

    protected void annotateKJarRoutes(RoutesDefinition routes, String deploymentId) {
        for (RouteDefinition route : routes.getRoutes()) {
            for (FromDefinition from : route.getInputs()) {
                if (from.getUri().startsWith("jbpm:events") && !from.getUri().contains("deploymentId")) {
                    StringBuilder uri = new StringBuilder(from.getUri());
                    String[] split = from.getUri().split("\\?");
                    if (split.length == 1) {
                        uri.append("?");
                    } else {
                        uri.append("&");
                    }
                    uri.append("deploymentId=").append(deploymentId);
                    from.setUri(uri.toString());
                }
                System.out.println(from.getUri());
            }
        }
    }
}

