/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kestrel;

import net.spy.memcached.MemcachedClient;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kestrel.KestrelComponent;
import org.apache.camel.component.kestrel.KestrelConfiguration;
import org.apache.camel.component.kestrel.KestrelConsumer;
import org.apache.camel.component.kestrel.KestrelProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.6.0", scheme="kestrel", title="Kestrel", syntax="kestrel:addresses/queue", consumerClass=KestrelConsumer.class, label="messaging")
public class KestrelEndpoint
extends DefaultEndpoint {
    @UriParam
    private KestrelConfiguration configuration;
    @UriPath
    @Metadata(required="true")
    private String queue;
    private KestrelComponent component;

    public KestrelEndpoint(String endPointURI, KestrelComponent component, KestrelConfiguration configuration, String queue) {
        super(endPointURI, (Component)component);
        this.component = component;
        this.configuration = configuration;
        this.queue = queue;
    }

    public KestrelConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KestrelConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public Producer createProducer() throws Exception {
        return new KestrelProducer(this, this.getMemcachedClient());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KestrelConsumer answer = new KestrelConsumer(this, processor, this.getMemcachedClient());
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    private MemcachedClient getMemcachedClient() {
        return this.component.getMemcachedClient(this.configuration, this.queue);
    }

    public boolean isSingleton() {
        return true;
    }
}

