/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.camel.Exchange;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.file.strategy.MarkerFileExclusiveReadLockStrategy;
import org.apache.camel.util.CamelLogger;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLockExclusiveReadLockStrategy
extends MarkerFileExclusiveReadLockStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(FileLockExclusiveReadLockStrategy.class);
    private long timeout;
    private long checkInterval = 1000L;
    private LoggingLevel readLockLoggingLevel = LoggingLevel.DEBUG;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        if (!super.acquireExclusiveReadLock(operations, file, exchange)) {
            return false;
        }
        File target = new File(file.getAbsoluteFilePath());
        LOG.trace("Waiting for exclusive read lock to file: {}", (Object)target);
        FileChannel channel = null;
        RandomAccessFile randomAccessFile = null;
        boolean exclusive = false;
        FileLock lock = null;
        try {
            randomAccessFile = new RandomAccessFile(target, "rw");
            channel = randomAccessFile.getChannel();
            StopWatch watch = new StopWatch();
            while (!exclusive) {
                long delta22;
                if (this.timeout > 0L && (delta22 = watch.taken()) > this.timeout) {
                    CamelLogger.log(LOG, this.readLockLoggingLevel, "Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + target);
                    boolean bl = false;
                    return bl;
                }
                try {
                    lock = this.timeout > 0L ? channel.tryLock() : channel.lock();
                }
                catch (IllegalStateException delta22) {
                    // empty catch block
                }
                if (lock != null) {
                    LOG.trace("Acquired exclusive read lock: {} to file: {}", (Object)lock, (Object)target);
                    exclusive = true;
                    continue;
                }
                boolean interrupted = this.sleep();
                if (!interrupted) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            if (this.timeout == 0L) {
                boolean interrupted = false;
                return interrupted;
            }
            LOG.debug("Cannot acquire read lock. Will try again.", (Throwable)e);
            boolean interrupted = this.sleep();
            if (interrupted) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (!exclusive) {
                IOHelper.close((Closeable)channel, "while acquiring exclusive read lock for file: " + target, LOG);
                IOHelper.close((Closeable)randomAccessFile, "while acquiring exclusive read lock for file: " + target, LOG);
                super.releaseExclusiveReadLockOnAbort(operations, file, exchange);
            }
        }
        exchange.setProperty(FileLockExclusiveReadLockStrategy.asReadLockKey(file, "CamelFileLockExclusiveLock"), lock);
        exchange.setProperty(FileLockExclusiveReadLockStrategy.asReadLockKey(file, "CamelFileLockRandomAccessFile"), randomAccessFile);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReleaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        super.doReleaseExclusiveReadLock(operations, file, exchange);
        FileLock lock = exchange.getProperty(FileLockExclusiveReadLockStrategy.asReadLockKey(file, "CamelFileLockExclusiveLock"), FileLock.class);
        RandomAccessFile rac = exchange.getProperty(FileLockExclusiveReadLockStrategy.asReadLockKey(file, "CamelFileLockExclusiveLock"), RandomAccessFile.class);
        String target = file.getFileName();
        if (lock != null) {
            Channel channel = lock.acquiredBy();
            try {
                lock.release();
            }
            finally {
                IOHelper.close((Closeable)channel, "while releasing exclusive read lock for file: " + target, LOG);
                IOHelper.close((Closeable)rac, "while releasing exclusive read lock for file: " + target, LOG);
            }
        }
    }

    private boolean sleep() {
        LOG.trace("Exclusive read lock not granted. Sleeping for {} millis.", (Object)this.checkInterval);
        try {
            Thread.sleep(this.checkInterval);
            return false;
        }
        catch (InterruptedException e) {
            LOG.debug("Sleep interrupted while waiting for exclusive read lock, so breaking out");
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public void setCheckInterval(long checkInterval) {
        this.checkInterval = checkInterval;
    }

    @Override
    public void setReadLockLoggingLevel(LoggingLevel readLockLoggingLevel) {
        this.readLockLoggingLevel = readLockLoggingLevel;
    }

    private static String asReadLockKey(GenericFile file, String key) {
        String path = file.getCopyFromAbsoluteFilePath() != null ? file.getCopyFromAbsoluteFilePath() : file.getAbsoluteFilePath();
        return path + "-" + key;
    }
}

