/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.core.osgi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.core.osgi.OsgiCamelContextHelper;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.util.ObjectHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiServiceRegistry
extends LifecycleStrategySupport
implements Registry {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiCamelContextHelper.class);
    private final BundleContext bundleContext;
    private final Queue<ServiceReference<?>> serviceReferenceQueue = new ConcurrentLinkedQueue();

    public OsgiServiceRegistry(BundleContext bc) {
        this.bundleContext = bc;
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        Object service = null;
        ServiceReference sr = null;
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(type.getName(), "(name=" + name + ")");
            if (refs != null && refs.length > 0) {
                sr = refs[0];
                this.serviceReferenceQueue.add(sr);
                service = this.bundleContext.getService(sr);
            }
        }
        catch (Exception ex) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)ex);
        }
        return type.cast(service);
    }

    public Object lookupByName(String name) {
        ServiceReference sr;
        Object service;
        block5: {
            service = null;
            sr = this.bundleContext.getServiceReference(name);
            if (sr == null) {
                String filterExpression = "(service.pid=" + name + ")";
                try {
                    ServiceReference[] refs = this.bundleContext.getServiceReferences((String)null, filterExpression);
                    if (refs != null && refs.length > 0) {
                        sr = refs[0];
                    }
                }
                catch (InvalidSyntaxException ex) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug("Invalid OSGi service reference filter, skipped lookup by service.pid. Filter expression: {}", (Object)filterExpression, (Object)ex);
                }
            }
        }
        if (sr != null) {
            this.serviceReferenceQueue.add(sr);
            service = this.bundleContext.getService(sr);
        }
        return service;
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        HashMap<String, T> result = new HashMap<String, T>();
        int count = 0;
        try {
            ServiceReference[] refs = this.bundleContext.getAllServiceReferences(type.getName(), null);
            if (refs != null) {
                for (ServiceReference sr : refs) {
                    if (sr == null) continue;
                    Object service = this.bundleContext.getService(sr);
                    this.serviceReferenceQueue.add(sr);
                    if (service == null) continue;
                    String name = (String)sr.getProperty("name");
                    if (name != null) {
                        result.put(name, type.cast(service));
                        continue;
                    }
                    result.put(type.getSimpleName() + count, type.cast(service));
                    ++count;
                }
            }
        }
        catch (Exception ex) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)ex);
        }
        return result;
    }

    public <T> Set<T> findByType(Class<T> type) {
        Map<String, T> map = this.findByTypeWithName(type);
        return new HashSet<T>(map.values());
    }

    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }

    public void onContextStop(CamelContext context) {
        ServiceReference<?> sr = this.serviceReferenceQueue.poll();
        while (sr != null) {
            this.bundleContext.ungetService(sr);
            sr = this.serviceReferenceQueue.poll();
        }
        this.serviceReferenceQueue.clear();
    }
}

