/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.processor;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.camel.BytesSource;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.validator.DefaultLSResourceResolver;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureConstants;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureException;
import org.apache.camel.component.xmlsecurity.processor.SantuarioUtil;
import org.apache.camel.component.xmlsecurity.processor.XmlSignatureConfiguration;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public abstract class XmlSignatureProcessor
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSignatureProcessor.class);

    public abstract XmlSignatureConfiguration getConfiguration();

    void setUriDereferencerAndBaseUri(XMLCryptoContext context) {
        this.setUriDereferencer(context);
        this.setBaseUri(context);
    }

    private void setUriDereferencer(XMLCryptoContext context) {
        if (this.getConfiguration().getUriDereferencer() != null) {
            context.setURIDereferencer(this.getConfiguration().getUriDereferencer());
            LOG.debug("URI dereferencer set");
        }
    }

    private void setBaseUri(XMLCryptoContext context) {
        if (this.getConfiguration().getBaseUri() != null) {
            context.setBaseURI(this.getConfiguration().getBaseUri());
            LOG.debug("Base URI {} set", (Object)context.getBaseURI());
        }
    }

    protected void setCryptoContextProperties(XMLCryptoContext cryptoContext) {
        Map<String, ? extends Object> props = this.getConfiguration().getCryptoContextProperties();
        if (props == null) {
            return;
        }
        for (String prop : props.keySet()) {
            Object val = props.get(prop);
            cryptoContext.setProperty(prop, val);
            LOG.debug("Context property {} set to value {}", (Object)prop, val);
        }
    }

    protected void clearMessageHeaders(Message message) {
        if (this.getConfiguration().getClearHeaders() != null && this.getConfiguration().getClearHeaders().booleanValue()) {
            Map headers = message.getHeaders();
            for (Field f : XmlSignatureConstants.class.getFields()) {
                headers.remove(ObjectHelper.lookupConstantFieldValue(XmlSignatureConstants.class, (String)f.getName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getSchema(Message message) throws SAXException, XmlSignatureException, IOException {
        String schemaResourceUri = this.getSchemaResourceUri(message);
        if (schemaResourceUri == null || schemaResourceUri.isEmpty()) {
            return null;
        }
        InputStream is = ResourceHelper.resolveResourceAsInputStream((ClassResolver)this.getConfiguration().getCamelContext().getClassResolver(), (String)schemaResourceUri);
        if (is == null) {
            throw new XmlSignatureException("XML Signature component is wrongly configured: No XML schema found for specified schema resource URI " + schemaResourceUri);
        }
        byte[] bytes = null;
        try {
            bytes = IOConverter.toBytes((InputStream)is);
        }
        finally {
            IOHelper.close((Closeable)is);
        }
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        schemaFactory.setResourceResolver((LSResourceResolver)new DefaultLSResourceResolver(this.getConfiguration().getCamelContext(), this.getConfiguration().getSchemaResourceUri()));
        LOG.debug("Instantiating schema for validation");
        return schemaFactory.newSchema((Source)new BytesSource(bytes));
    }

    protected String getSchemaResourceUri(Message message) {
        String schemaResourceUri = (String)message.getHeader("CamelXmlSignatureSchemaResourceUri", String.class);
        if (schemaResourceUri == null) {
            schemaResourceUri = this.getConfiguration().getSchemaResourceUri();
        }
        LOG.debug("schema resource URI: {}", (Object)this.getConfiguration().getSchemaResourceUri());
        return schemaResourceUri;
    }

    static {
        try {
            SantuarioUtil.initializeSantuario();
            SantuarioUtil.addSantuarioJSR105Provider();
        }
        catch (Throwable t) {
            LOG.info("Cannot add the SantuarioJSR105Provider due to {0}, fall back to JRE default.", t);
        }
    }
}

