/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.cms.crypt;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.crypto.cms.common.DefaultCryptoCmsUnMarshallerConfiguration;
import org.apache.camel.component.crypto.cms.crypt.EnvelopedDataDecryptorConfiguration;
import org.apache.camel.component.crypto.cms.crypt.PrivateKeyWithCertificate;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class DefaultEnvelopedDataDecryptorConfiguration
extends DefaultCryptoCmsUnMarshallerConfiguration
implements EnvelopedDataDecryptorConfiguration,
Cloneable {
    @UriParam(label="decrypt")
    private char[] password;

    public void setPassword(char[] password) {
        this.password = password;
    }

    protected char[] getPassword(Exchange exchange) throws CryptoCmsException {
        if (this.password == null) {
            if (this.getKeyStoreParameters() != null) {
                String passwordS = this.getKeyStoreParameters().getPassword();
                if (passwordS == null) {
                    throw new CryptoCmsException("Password for private keys not configured");
                }
                return passwordS.toCharArray();
            }
            throw new CryptoCmsException("Password for private keys not configured");
        }
        return this.password;
    }

    @Override
    public Collection<PrivateKeyWithCertificate> getPrivateKeyCertificateCollection(Exchange exchange) throws CryptoCmsException {
        KeyStore keystore = this.getKeyStore();
        try {
            ArrayList<PrivateKeyWithCertificate> privateKeys = new ArrayList<PrivateKeyWithCertificate>(keystore.size());
            Enumeration<String> aliases = keystore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate cert;
                Key privateKey;
                String alias = aliases.nextElement();
                if (!keystore.isKeyEntry(alias) || !((privateKey = keystore.getKey(alias, this.getPassword(exchange))) instanceof PrivateKey) || !((cert = keystore.getCertificate(alias)) instanceof X509Certificate)) continue;
                privateKeys.add(new PrivateKeyWithCertificate((PrivateKey)privateKey, (X509Certificate)cert));
            }
            if (privateKeys.isEmpty()) {
                throw new CryptoCmsException("No private keys in keystore found. Check your configuration.");
            }
            return privateKeys;
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new CryptoCmsException("Problem during reading the private keys from the keystore", e);
        }
    }

    @Override
    public DefaultEnvelopedDataDecryptorConfiguration copy() {
        try {
            return (DefaultEnvelopedDataDecryptorConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }
}

