/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mongodb3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mongodb3.CamelMongoDbException;
import org.apache.camel.component.mongodb3.MongoDbComponent;
import org.apache.camel.component.mongodb3.MongoDbConsumerType;
import org.apache.camel.component.mongodb3.MongoDbOperation;
import org.apache.camel.component.mongodb3.MongoDbOutputType;
import org.apache.camel.component.mongodb3.MongoDbProducer;
import org.apache.camel.component.mongodb3.MongoDbTailTrackingConfig;
import org.apache.camel.component.mongodb3.MongoDbTailableCursorConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.19.0", scheme="mongodb3", title="MongoDB", syntax="mongodb3:connectionBean", consumerClass=MongoDbTailableCursorConsumer.class, label="database,nosql")
public class MongoDbEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbEndpoint.class);
    private MongoClient mongoConnection;
    @UriPath
    @Metadata(required="true")
    private String connectionBean;
    @UriParam
    private String database;
    @UriParam
    private String collection;
    @UriParam
    private String collectionIndex;
    @UriParam
    private MongoDbOperation operation;
    @UriParam(defaultValue="true")
    private boolean createCollection = true;
    private WriteConcern writeConcernRef;
    @UriParam(label="advanced")
    private boolean dynamicity;
    @UriParam(label="advanced")
    private boolean writeResultAsHeader;
    private MongoDbConsumerType consumerType;
    @UriParam(label="advanced", defaultValue="1000")
    private long cursorRegenerationDelay = 1000L;
    @UriParam(label="tail")
    private String tailTrackIncreasingField;
    @UriParam(label="tail")
    private boolean persistentTailTracking;
    @UriParam(label="tail")
    private String persistentId;
    @UriParam(label="tail")
    private String tailTrackDb;
    @UriParam(label="tail")
    private String tailTrackCollection;
    @UriParam(label="tail")
    private String tailTrackField;
    @UriParam(label="common")
    private MongoDbOutputType outputType;
    private MongoDbTailTrackingConfig tailTrackingConfig;
    private MongoDatabase mongoDatabase;
    private MongoCollection<Document> mongoCollection;

    public MongoDbEndpoint() {
    }

    public MongoDbEndpoint(String uri, MongoDbComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        this.validateProducerOptions();
        this.initializeConnection();
        return new MongoDbProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.validateConsumerOptions();
        this.createCollection = false;
        this.initializeConnection();
        if (this.consumerType == null) {
            this.consumerType = MongoDbConsumerType.tailable;
        }
        if (this.consumerType != MongoDbConsumerType.tailable) {
            throw new CamelMongoDbException("Consumer type not supported: " + (Object)((Object)this.consumerType));
        }
        MongoDbTailableCursorConsumer consumer = new MongoDbTailableCursorConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    private void validateOutputType() {
        if (!ObjectHelper.isEmpty((Object)((Object)this.outputType))) {
            if (MongoDbOutputType.DocumentList.equals((Object)this.outputType) && !MongoDbOperation.findAll.equals((Object)this.operation)) {
                throw new IllegalArgumentException("outputType DocumentList is only compatible with operation findAll");
            }
            if (MongoDbOutputType.MongoIterable.equals((Object)this.outputType) && !MongoDbOperation.findAll.equals((Object)this.operation)) {
                throw new IllegalArgumentException("outputType MongoIterable is only compatible with operation findAll");
            }
            if (MongoDbOutputType.Document.equals((Object)this.outputType) && MongoDbOperation.findAll.equals((Object)this.operation)) {
                throw new IllegalArgumentException("outputType Document is not compatible with operation findAll");
            }
        }
    }

    private void validateProducerOptions() throws IllegalArgumentException {
        if (!(ObjectHelper.isEmpty((Object)((Object)this.consumerType)) && !this.persistentTailTracking && ObjectHelper.isEmpty((Object)this.tailTrackDb) && ObjectHelper.isEmpty((Object)this.tailTrackCollection) && ObjectHelper.isEmpty((Object)this.tailTrackField) && this.cursorRegenerationDelay == 1000L)) {
            throw new IllegalArgumentException("consumerType, tailTracking, cursorRegenerationDelay options cannot appear on a producer endpoint");
        }
    }

    private void validateConsumerOptions() throws IllegalArgumentException {
        if (!ObjectHelper.isEmpty((Object)((Object)this.operation)) || this.dynamicity || this.outputType != null) {
            throw new IllegalArgumentException("operation, dynamicity, outputType options cannot appear on a consumer endpoint");
        }
        if (this.consumerType == MongoDbConsumerType.tailable) {
            if (this.tailTrackIncreasingField == null) {
                throw new IllegalArgumentException("tailTrackIncreasingField option must be set for tailable cursor MongoDB consumer endpoint");
            }
            if (this.persistentTailTracking && ObjectHelper.isEmpty((Object)this.persistentId)) {
                throw new IllegalArgumentException("persistentId is compulsory for persistent tail tracking");
            }
        }
    }

    public boolean isSingleton() {
        return true;
    }

    public void initializeConnection() throws CamelMongoDbException {
        LOG.info("Initialising MongoDb endpoint: {}", (Object)this.toString());
        if (this.database == null || this.collection == null && !MongoDbOperation.getDbStats.equals((Object)this.operation) && !MongoDbOperation.command.equals((Object)this.operation)) {
            throw new CamelMongoDbException("Missing required endpoint configuration: database and/or collection");
        }
        this.mongoDatabase = this.mongoConnection.getDatabase(this.database);
        if (this.mongoDatabase == null) {
            throw new CamelMongoDbException("Could not initialise MongoDbComponent. Database " + this.database + " does not exist.");
        }
        if (this.collection != null) {
            if (!this.createCollection && !this.databaseContainsCollection(this.collection)) {
                throw new CamelMongoDbException("Could not initialise MongoDbComponent. Collection " + this.collection + " and createCollection is false.");
            }
            this.mongoCollection = this.mongoDatabase.getCollection(this.collection, Document.class);
            LOG.debug("MongoDb component initialised and endpoint bound to MongoDB collection with the following parameters. Address list: {}, Db: {}, Collection: {}", new Object[]{this.mongoConnection.getAllAddress().toString(), this.mongoDatabase.getName(), this.collection});
            try {
                if (ObjectHelper.isNotEmpty((Object)this.collectionIndex)) {
                    this.ensureIndex(this.mongoCollection, this.createIndex());
                }
            }
            catch (Exception e) {
                throw new CamelMongoDbException("Error creating index", e);
            }
        }
    }

    private boolean databaseContainsCollection(String collectionName) {
        return StreamSupport.stream(this.mongoDatabase.listCollectionNames().spliterator(), false).anyMatch(collectionName::equals);
    }

    public void ensureIndex(MongoCollection<Document> aCollection, List<Bson> dynamicIndex) {
        if (dynamicIndex != null && !dynamicIndex.isEmpty()) {
            for (Bson index : dynamicIndex) {
                LOG.debug("create Document Index {}", (Object)index);
                aCollection.createIndex(index);
            }
        }
    }

    public List<Bson> createIndex() {
        try {
            ArrayList<Bson> indexList = new ArrayList<Bson>();
            if (ObjectHelper.isNotEmpty((Object)this.collectionIndex)) {
                HashMap indexMap = (HashMap)new ObjectMapper().readValue(this.collectionIndex, HashMap.class);
                for (Map.Entry set : indexMap.entrySet()) {
                    Document index = new Document();
                    index.put((String)set.getKey(), set.getValue());
                    indexList.add((Bson)index);
                }
            }
            return indexList;
        }
        catch (IOException e) {
            throw new CamelMongoDbException("createIndex failed", e);
        }
    }

    public Exchange createMongoDbExchange(Document dbObj) {
        Exchange exchange = super.createExchange();
        Message message = exchange.getIn();
        message.setHeader("CamelMongoDbDatabase", (Object)this.database);
        message.setHeader("CamelMongoDbCollection", (Object)this.collection);
        message.setHeader("CamelMongoDbTailable", (Object)true);
        message.setBody((Object)dbObj);
        return exchange;
    }

    protected void doStart() throws Exception {
        this.mongoConnection = (MongoClient)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.connectionBean, MongoClient.class);
        LOG.debug("Resolved the connection with the name {} as {}", (Object)this.connectionBean, (Object)this.mongoConnection);
        super.doStart();
    }

    public String getConnectionBean() {
        return this.connectionBean;
    }

    public void setConnectionBean(String connectionBean) {
        this.connectionBean = connectionBean;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollectionIndex(String collectionIndex) {
        this.collectionIndex = collectionIndex;
    }

    public String getCollectionIndex() {
        return this.collectionIndex;
    }

    public void setOperation(String operation) throws CamelMongoDbException {
        try {
            this.operation = MongoDbOperation.valueOf(operation);
        }
        catch (IllegalArgumentException e) {
            throw new CamelMongoDbException("Operation not supported", e);
        }
    }

    public MongoDbOperation getOperation() {
        return this.operation;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setCreateCollection(boolean createCollection) {
        this.createCollection = createCollection;
    }

    public boolean isCreateCollection() {
        return this.createCollection;
    }

    public void setMongoConnection(MongoClient mongoConnection) {
        this.mongoConnection = mongoConnection;
    }

    public MongoClient getMongoConnection() {
        return this.mongoConnection;
    }

    public WriteConcern getWriteConcern() {
        return this.getMongoConnection().getWriteConcern();
    }

    public void setWriteConcernRef(String writeConcernRef) {
        WriteConcern wc = (WriteConcern)this.getCamelContext().getRegistry().lookupByNameAndType(writeConcernRef, WriteConcern.class);
        if (wc == null) {
            String msg = "Camel MongoDB component could not find the WriteConcern in the Registry. Verify that the provided bean name (" + writeConcernRef + ")  is correct. Aborting initialization.";
            throw new IllegalArgumentException(msg);
        }
        this.writeConcernRef = wc;
    }

    public WriteConcern getWriteConcernRef() {
        return this.writeConcernRef;
    }

    public ReadPreference getReadPreference() {
        return this.getMongoConnection().getReadPreference();
    }

    public void setDynamicity(boolean dynamicity) {
        this.dynamicity = dynamicity;
    }

    public boolean isDynamicity() {
        return this.dynamicity;
    }

    public void setConsumerType(String consumerType) throws CamelMongoDbException {
        try {
            this.consumerType = MongoDbConsumerType.valueOf(consumerType);
        }
        catch (IllegalArgumentException e) {
            throw new CamelMongoDbException("Consumer type not supported", e);
        }
    }

    public MongoDbConsumerType getConsumerType() {
        return this.consumerType;
    }

    public String getTailTrackDb() {
        return this.tailTrackDb;
    }

    public void setTailTrackDb(String tailTrackDb) {
        this.tailTrackDb = tailTrackDb;
    }

    public String getTailTrackCollection() {
        return this.tailTrackCollection;
    }

    public void setTailTrackCollection(String tailTrackCollection) {
        this.tailTrackCollection = tailTrackCollection;
    }

    public String getTailTrackField() {
        return this.tailTrackField;
    }

    public void setTailTrackField(String tailTrackField) {
        this.tailTrackField = tailTrackField;
    }

    public void setPersistentTailTracking(boolean persistentTailTracking) {
        this.persistentTailTracking = persistentTailTracking;
    }

    public boolean isPersistentTailTracking() {
        return this.persistentTailTracking;
    }

    public void setTailTrackIncreasingField(String tailTrackIncreasingField) {
        this.tailTrackIncreasingField = tailTrackIncreasingField;
    }

    public String getTailTrackIncreasingField() {
        return this.tailTrackIncreasingField;
    }

    public MongoDbTailTrackingConfig getTailTrackingConfig() {
        if (this.tailTrackingConfig == null) {
            this.tailTrackingConfig = new MongoDbTailTrackingConfig(this.persistentTailTracking, this.tailTrackIncreasingField, this.tailTrackDb == null ? this.database : this.tailTrackDb, this.tailTrackCollection, this.tailTrackField, this.getPersistentId());
        }
        return this.tailTrackingConfig;
    }

    public void setCursorRegenerationDelay(long cursorRegenerationDelay) {
        this.cursorRegenerationDelay = cursorRegenerationDelay;
    }

    public long getCursorRegenerationDelay() {
        return this.cursorRegenerationDelay;
    }

    public void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    public boolean isWriteResultAsHeader() {
        return this.writeResultAsHeader;
    }

    public void setWriteResultAsHeader(boolean writeResultAsHeader) {
        this.writeResultAsHeader = writeResultAsHeader;
    }

    public MongoDbOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(MongoDbOutputType outputType) {
        this.outputType = outputType;
    }

    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    public MongoCollection<Document> getMongoCollection() {
        return this.mongoCollection;
    }
}

