/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelException;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.bulk.BatchInfo;
import org.apache.camel.component.salesforce.api.dto.bulk.ContentType;
import org.apache.camel.component.salesforce.api.dto.bulk.JobInfo;
import org.apache.camel.component.salesforce.internal.client.BulkApiClient;
import org.apache.camel.component.salesforce.internal.client.DefaultBulkApiClient;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.converter.stream.StreamCacheConverter;
import org.apache.camel.util.ServiceHelper;

public class BulkApiProcessor
extends AbstractSalesforceProcessor {
    private BulkApiClient bulkClient;

    public BulkApiProcessor(SalesforceEndpoint endpoint) throws SalesforceException {
        super(endpoint);
        this.bulkClient = new DefaultBulkApiClient((String)this.endpointConfigMap.get("apiVersion"), this.session, this.httpClient);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        boolean done = false;
        try {
            switch (this.operationName) {
                case CREATE_JOB: {
                    this.processCreateJob(exchange, callback);
                    break;
                }
                case GET_JOB: {
                    this.processGetJob(exchange, callback);
                    break;
                }
                case CLOSE_JOB: {
                    this.processCloseJob(exchange, callback);
                    break;
                }
                case ABORT_JOB: {
                    this.processAbortJob(exchange, callback);
                    break;
                }
                case CREATE_BATCH: {
                    this.processCreateBatch(exchange, callback);
                    break;
                }
                case GET_BATCH: {
                    this.processGetBatch(exchange, callback);
                    break;
                }
                case GET_ALL_BATCHES: {
                    this.processGetAllBatches(exchange, callback);
                    break;
                }
                case GET_REQUEST: {
                    this.processGetRequest(exchange, callback);
                    break;
                }
                case GET_RESULTS: {
                    this.processGetResults(exchange, callback);
                    break;
                }
                case CREATE_BATCH_QUERY: {
                    this.processCreateBatchQuery(exchange, callback);
                    break;
                }
                case GET_QUERY_RESULT_IDS: {
                    this.processGetQueryResultIds(exchange, callback);
                    break;
                }
                case GET_QUERY_RESULT: {
                    this.processGetQueryResult(exchange, callback);
                    break;
                }
                default: {
                    throw new SalesforceException("Unknown operation name: " + this.operationName.value(), null);
                }
            }
        }
        catch (SalesforceException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Error processing %s: [%s] \"%s\"", this.operationName.value(), e.getStatusCode(), e.getMessage()), (Throwable)((Object)e))));
            callback.done(true);
            done = true;
        }
        catch (InvalidPayloadException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e)));
            callback.done(true);
            done = true;
        }
        catch (RuntimeException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", this.operationName.value(), e.getMessage()), e)));
            callback.done(true);
            done = true;
        }
        return done;
    }

    private void processCreateJob(final Exchange exchange, final AsyncCallback callback) throws InvalidPayloadException {
        JobInfo jobBody = (JobInfo)exchange.getIn().getMandatoryBody(JobInfo.class);
        this.bulkClient.createJob(jobBody, this.determineHeaders(exchange), new BulkApiClient.JobInfoResponseCallback(){

            @Override
            public void onResponse(JobInfo jobInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, jobInfo, headers, ex, callback);
            }
        });
    }

    private void processGetJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        JobInfo jobBody = (JobInfo)exchange.getIn().getBody(JobInfo.class);
        String jobId = jobBody != null ? jobBody.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.getJob(jobId, this.determineHeaders(exchange), new BulkApiClient.JobInfoResponseCallback(){

            @Override
            public void onResponse(JobInfo jobInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, jobInfo, headers, ex, callback);
            }
        });
    }

    private void processCloseJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        JobInfo jobBody = (JobInfo)exchange.getIn().getBody(JobInfo.class);
        String jobId = jobBody != null ? jobBody.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.closeJob(jobId, this.determineHeaders(exchange), new BulkApiClient.JobInfoResponseCallback(){

            @Override
            public void onResponse(JobInfo jobInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, jobInfo, headers, ex, callback);
            }
        });
    }

    private void processAbortJob(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        JobInfo jobBody = (JobInfo)exchange.getIn().getBody(JobInfo.class);
        String jobId = jobBody != null ? jobBody.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.abortJob(jobId, this.determineHeaders(exchange), new BulkApiClient.JobInfoResponseCallback(){

            @Override
            public void onResponse(JobInfo jobInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, jobInfo, headers, ex, callback);
            }
        });
    }

    private void processCreateBatch(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        InputStream request;
        ContentType contentType = ContentType.fromValue(this.getParameter("contentType", exchange, false, false));
        String jobId = this.getParameter("jobId", exchange, false, false);
        try {
            request = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        }
        catch (CamelException e) {
            String msg = "Error preparing batch request: " + e.getMessage();
            throw new SalesforceException(msg, e);
        }
        this.bulkClient.createBatch(request, jobId, contentType, this.determineHeaders(exchange), new BulkApiClient.BatchInfoResponseCallback(){

            @Override
            public void onResponse(BatchInfo batchInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, batchInfo, headers, ex, callback);
            }
        });
    }

    private void processGetBatch(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String batchId;
        String jobId;
        BatchInfo batchBody = (BatchInfo)exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, true, false);
        }
        this.bulkClient.getBatch(jobId, batchId, this.determineHeaders(exchange), new BulkApiClient.BatchInfoResponseCallback(){

            @Override
            public void onResponse(BatchInfo batchInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, batchInfo, headers, ex, callback);
            }
        });
    }

    private void processGetAllBatches(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        JobInfo jobBody = (JobInfo)exchange.getIn().getBody(JobInfo.class);
        String jobId = jobBody != null ? jobBody.getId() : this.getParameter("jobId", exchange, true, false);
        this.bulkClient.getAllBatches(jobId, this.determineHeaders(exchange), new BulkApiClient.BatchInfoListResponseCallback(){

            @Override
            public void onResponse(List<BatchInfo> batchInfoList, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, batchInfoList, headers, ex, callback);
            }
        });
    }

    private void processGetRequest(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String batchId;
        String jobId;
        BatchInfo batchBody = (BatchInfo)exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, true, false);
        }
        this.bulkClient.getRequest(jobId, batchId, this.determineHeaders(exchange), new BulkApiClient.StreamResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                StreamCache body = null;
                if (inputStream != null) {
                    try {
                        body = StreamCacheConverter.convertToStreamCache((InputStream)inputStream, (Exchange)exchange);
                    }
                    catch (IOException e) {
                        String msg = "Error retrieving batch request: " + e.getMessage();
                        ex = new SalesforceException(msg, e);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                BulkApiProcessor.this.processResponse(exchange, body, headers, ex, callback);
            }
        });
    }

    private void processGetResults(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String batchId;
        String jobId;
        BatchInfo batchBody = (BatchInfo)exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, true, false);
        }
        this.bulkClient.getResults(jobId, batchId, this.determineHeaders(exchange), new BulkApiClient.StreamResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                StreamCache body = null;
                if (inputStream != null) {
                    try {
                        body = StreamCacheConverter.convertToStreamCache((InputStream)inputStream, (Exchange)exchange);
                    }
                    catch (IOException e) {
                        String msg = "Error retrieving batch results: " + e.getMessage();
                        ex = new SalesforceException(msg, e);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                BulkApiProcessor.this.processResponse(exchange, body, headers, ex, callback);
            }
        });
    }

    private void processCreateBatchQuery(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String soqlQuery;
        ContentType contentType;
        String jobId;
        JobInfo jobBody = (JobInfo)exchange.getIn().getBody(JobInfo.class);
        if (jobBody != null) {
            jobId = jobBody.getId();
            contentType = jobBody.getContentType();
            soqlQuery = this.getParameter("sObjectQuery", exchange, false, false);
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            contentType = ContentType.fromValue(this.getParameter("contentType", exchange, false, false));
            soqlQuery = this.getParameter("sObjectQuery", exchange, true, false);
        }
        this.bulkClient.createBatchQuery(jobId, soqlQuery, contentType, this.determineHeaders(exchange), new BulkApiClient.BatchInfoResponseCallback(){

            @Override
            public void onResponse(BatchInfo batchInfo, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, batchInfo, headers, ex, callback);
            }
        });
    }

    private void processGetQueryResultIds(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String batchId;
        String jobId;
        BatchInfo batchBody = (BatchInfo)exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, true, false);
        }
        this.bulkClient.getQueryResultIds(jobId, batchId, this.determineHeaders(exchange), new BulkApiClient.QueryResultIdsCallback(){

            @Override
            public void onResponse(List<String> ids, Map<String, String> headers, SalesforceException ex) {
                BulkApiProcessor.this.processResponse(exchange, ids, headers, ex, callback);
            }
        });
    }

    private void processGetQueryResult(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String resultId;
        String batchId;
        String jobId;
        BatchInfo batchBody = (BatchInfo)exchange.getIn().getBody(BatchInfo.class);
        if (batchBody != null) {
            jobId = batchBody.getJobId();
            batchId = batchBody.getId();
            resultId = this.getParameter("resultId", exchange, false, false);
        } else {
            jobId = this.getParameter("jobId", exchange, false, false);
            batchId = this.getParameter("batchId", exchange, false, false);
            resultId = this.getParameter("resultId", exchange, true, false);
        }
        this.bulkClient.getQueryResult(jobId, batchId, resultId, this.determineHeaders(exchange), new BulkApiClient.StreamResponseCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(InputStream inputStream, Map<String, String> headers, SalesforceException ex) {
                StreamCache body = null;
                if (inputStream != null) {
                    try {
                        body = StreamCacheConverter.convertToStreamCache((InputStream)inputStream, (Exchange)exchange);
                    }
                    catch (IOException e) {
                        String msg = "Error retrieving query result: " + e.getMessage();
                        ex = new SalesforceException(msg, e);
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                BulkApiProcessor.this.processResponse(exchange, body, headers, ex, callback);
            }
        });
    }

    private void processResponse(Exchange exchange, Object body, Map<String, String> headers, SalesforceException ex, AsyncCallback callback) {
        Message out = exchange.getOut();
        if (ex != null) {
            exchange.setException((Throwable)((Object)ex));
        } else {
            out.setBody(body);
        }
        Message inboundMessage = exchange.getIn();
        Map outboundHeaders = out.getHeaders();
        outboundHeaders.putAll(inboundMessage.getHeaders());
        outboundHeaders.putAll(headers);
        out.copyAttachments(inboundMessage);
        callback.done(false);
    }

    public void start() throws Exception {
        ServiceHelper.startService((Object)this.bulkClient);
    }

    public void stop() throws Exception {
        ServiceHelper.stopService((Object)this.bulkClient);
    }
}

