/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.box.internal;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxDeveloperEditionAPIConnection;
import com.box.sdk.IAccessTokenCache;
import com.box.sdk.InMemoryLRUAccessTokenCache;
import com.box.sdk.JWTEncryptionPreferences;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.ProxyConfig;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.HtmlButton;
import com.gargoylesoftware.htmlunit.html.HtmlDivision;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPasswordInput;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import com.gargoylesoftware.htmlunit.html.HtmlTextInput;
import com.gargoylesoftware.htmlunit.util.WebConnectionWrapper;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.box.BoxConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.http.HttpHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoxConnectionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(BoxConnectionHelper.class);
    private static final Pattern QUERY_PARAM_PATTERN = Pattern.compile("&?([^=]+)=([^&]+)");

    private BoxConnectionHelper() {
    }

    public static BoxAPIConnection createConnection(BoxConfiguration configuration) {
        if (configuration.getAuthenticationType() == null) {
            throw new RuntimeCamelException("Box API connection failed: Authentication type not specified in configuration");
        }
        switch (configuration.getAuthenticationType()) {
            case "APP_ENTERPRISE_AUTHENTICATION": {
                return BoxConnectionHelper.createAppEnterpriseAuthenticatedConnection(configuration);
            }
            case "APP_USER_AUTHENTICATION": {
                return BoxConnectionHelper.createAppUserAuthenticatedConnection(configuration);
            }
            case "STANDARD_AUTHENTICATION": {
                return BoxConnectionHelper.createStandardAuthenticatedConnection(configuration);
            }
        }
        throw new RuntimeCamelException(String.format("Box API connection failed: Invalid authentication type '%s'", configuration.getAuthenticationType()));
    }

    public static BoxAPIConnection createStandardAuthenticatedConnection(BoxConfiguration configuration) {
        WebClient webClient = new WebClient();
        WebClientOptions options = webClient.getOptions();
        options.setRedirectEnabled(true);
        options.setJavaScriptEnabled(false);
        options.setThrowExceptionOnFailingStatusCode(true);
        options.setThrowExceptionOnScriptError(true);
        options.setPrintContentOnFailingStatusCode(LOG.isDebugEnabled());
        try {
            SSLContext sslContext = new SSLContextParameters().createSSLContext(null);
            options.setSSLClientProtocols(sslContext.createSSLEngine().getEnabledProtocols());
        }
        catch (GeneralSecurityException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        catch (IOException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        finally {
            if (webClient != null) {
                webClient.close();
            }
        }
        new WebConnectionWrapper(webClient){

            public WebResponse getResponse(WebRequest request) throws IOException {
                request.setAdditionalHeader("Accept-Encoding", "identity");
                return super.getResponse(request);
            }
        };
        Map<String, Object> httpParams = configuration.getHttpParams();
        if (httpParams != null && httpParams.get("http.route.default-proxy") != null) {
            HttpHost proxyHost = (HttpHost)httpParams.get("http.route.default-proxy");
            Boolean socksProxy = (Boolean)httpParams.get("http.route.socks-proxy");
            ProxyConfig proxyConfig = new ProxyConfig(proxyHost.getHostName(), proxyHost.getPort(), socksProxy != null ? socksProxy : false);
            options.setProxyConfig(proxyConfig);
        }
        try {
            String redirectQuery;
            String csrfToken = String.valueOf(new SecureRandom().nextLong());
            HtmlPage authPage = (HtmlPage)webClient.getPage(BoxConnectionHelper.authorizationUrl(configuration.getClientId(), csrfToken));
            HtmlDivision div = (HtmlDivision)authPage.getFirstByXPath("//div[contains(concat(' ', @class, ' '), ' error_message ')]");
            if (div != null) {
                String errorMessage = div.getTextContent().replaceAll("\\s+", " ").replaceAll(" Show Error Details", ":").trim();
                throw new IllegalArgumentException("Error authorizing application: " + errorMessage);
            }
            HtmlForm loginForm = authPage.getFormByName("login_form");
            HtmlTextInput login = (HtmlTextInput)loginForm.getInputByName("login");
            login.setText(configuration.getUserName());
            HtmlPasswordInput password = (HtmlPasswordInput)loginForm.getInputByName("password");
            password.setText(configuration.getUserPassword());
            HtmlSubmitInput submitInput = (HtmlSubmitInput)loginForm.getInputByName("login_submit");
            HtmlPage consentPage = (HtmlPage)submitInput.click();
            HtmlForm consentForm = consentPage.getFormByName("consent_form");
            HtmlButton consentAccept = consentForm.getButtonByName("consent_accept");
            webClient.getOptions().setRedirectEnabled(false);
            try {
                Page redirectPage = consentAccept.click();
                redirectQuery = redirectPage.getUrl().getQuery();
            }
            catch (FailingHttpStatusCodeException e) {
                if (e.getStatusCode() != 302) {
                    throw e;
                }
                String location = e.getResponse().getResponseHeaderValue("Location");
                redirectQuery = new URL(location).getQuery();
            }
            HashMap<String, String> params = new HashMap<String, String>();
            Matcher matcher = QUERY_PARAM_PATTERN.matcher(redirectQuery);
            while (matcher.find()) {
                params.put(matcher.group(1), matcher.group(2));
            }
            String state = (String)params.get("state");
            if (!csrfToken.equals(state)) {
                throw new SecurityException("Invalid CSRF code!");
            }
            String authorizationCode = (String)params.get("code");
            return new BoxAPIConnection(configuration.getClientId(), configuration.getClientSecret(), authorizationCode);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API connection failed: API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeCamelException(String.format("Box API connection failed: %s", e.getMessage()), (Throwable)e);
        }
    }

    public static BoxAPIConnection createAppUserAuthenticatedConnection(BoxConfiguration configuration) {
        JWTEncryptionPreferences encryptionPref = new JWTEncryptionPreferences();
        encryptionPref.setPublicKeyID(configuration.getPublicKeyId());
        try {
            encryptionPref.setPrivateKey(new String(Files.readAllBytes(Paths.get(configuration.getPrivateKeyFile(), new String[0]))));
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Box API connection failed: could not read privateKeyFile", (Throwable)e);
        }
        encryptionPref.setPrivateKeyPassword(configuration.getPrivateKeyPassword());
        encryptionPref.setEncryptionAlgorithm(configuration.getEncryptionAlgorithm());
        IAccessTokenCache accessTokenCache = configuration.getAccessTokenCache();
        if (accessTokenCache == null) {
            accessTokenCache = new InMemoryLRUAccessTokenCache(configuration.getMaxCacheEntries());
        }
        try {
            return BoxDeveloperEditionAPIConnection.getAppUserConnection((String)configuration.getUserId(), (String)configuration.getClientId(), (String)configuration.getClientSecret(), (JWTEncryptionPreferences)encryptionPref, (IAccessTokenCache)accessTokenCache);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API connection failed: API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public static BoxAPIConnection createAppEnterpriseAuthenticatedConnection(BoxConfiguration configuration) {
        JWTEncryptionPreferences encryptionPref = new JWTEncryptionPreferences();
        encryptionPref.setPublicKeyID(configuration.getPublicKeyId());
        try {
            encryptionPref.setPrivateKey(new String(Files.readAllBytes(Paths.get(configuration.getPrivateKeyFile(), new String[0]))));
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Box API connection failed: could not read privateKeyFile", (Throwable)e);
        }
        encryptionPref.setPrivateKeyPassword(configuration.getPrivateKeyPassword());
        encryptionPref.setEncryptionAlgorithm(configuration.getEncryptionAlgorithm());
        IAccessTokenCache accessTokenCache = configuration.getAccessTokenCache();
        if (accessTokenCache == null) {
            accessTokenCache = new InMemoryLRUAccessTokenCache(configuration.getMaxCacheEntries());
        }
        try {
            return BoxDeveloperEditionAPIConnection.getAppEnterpriseConnection((String)configuration.getEnterpriseId(), (String)configuration.getClientId(), (String)configuration.getClientSecret(), (JWTEncryptionPreferences)encryptionPref, (IAccessTokenCache)accessTokenCache);
        }
        catch (BoxAPIException e) {
            throw new RuntimeCamelException(String.format("Box API connection failed: API returned the error code %d\n\n%s", e.getResponseCode(), e.getResponse()), (Throwable)e);
        }
    }

    public static String authorizationUrl(String clientId, String stateToken) {
        return "https://account.box.com/api/oauth2/authorize?response_type=code&redirect_url=https%3A%2F%2Flocalhost%2F&client_id=" + clientId + "&state=" + stateToken;
    }
}

