/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.dozer;

import org.apache.camel.CamelContext;
import org.apache.camel.component.dozer.DozerEndpoint;
import org.apache.camel.converter.dozer.DozerBeanMapperConfiguration;
import org.apache.camel.converter.dozer.DozerThreadContextClassLoader;
import org.dozer.DozerBeanMapperBuilder;
import org.dozer.Mapper;
import org.dozer.el.DefaultELEngine;
import org.dozer.el.ELEngine;
import org.dozer.el.ELExpressionFactory;
import org.dozer.el.NoopELEngine;
import org.dozer.el.TcclELEngine;
import org.dozer.util.RuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MapperFactory.class);
    private final CamelContext camelContext;
    private final DozerBeanMapperConfiguration configuration;

    public MapperFactory(CamelContext camelContext, DozerBeanMapperConfiguration configuration) {
        this.camelContext = camelContext;
        this.configuration = configuration;
    }

    public Mapper create() {
        if (this.camelContext == null) {
            throw new IllegalStateException("CamelContext is null");
        }
        return this.parseConfiguration(this.configuration);
    }

    private Mapper parseConfiguration(DozerBeanMapperConfiguration configuration) {
        this.configureSettings();
        Mapper mapper = configuration == null ? DozerBeanMapperBuilder.buildDefault() : DozerBeanMapperBuilder.create().withMappingFiles(configuration.getMappingFiles()).withCustomConverters(configuration.getCustomConverters()).withEventListeners(configuration.getEventListeners()).withCustomConvertersWithIds(configuration.getCustomConvertersWithId()).withMappingBuilders(configuration.getBeanMappingBuilders()).withCustomFieldMapper(configuration.getCustomFieldMapper()).withELEngine(this.createELEngine()).build();
        mapper.getMappingMetadata();
        return mapper;
    }

    private void configureSettings() {
        System.setProperty("dozer.beans.class-loader-bean", DozerThreadContextClassLoader.class.getName());
    }

    private ELEngine createELEngine() {
        Object answer;
        ClassLoader auxcl;
        ClassLoader appcl = this.camelContext.getApplicationContextClassLoader();
        ClassLoader classLoader = auxcl = appcl == null ? DozerEndpoint.class.getClassLoader() : appcl;
        if (ELExpressionFactory.isSupported((ClassLoader)auxcl).booleanValue()) {
            answer = RuntimeUtils.isOSGi() ? new TcclELEngine(ELExpressionFactory.newInstance((ClassLoader)auxcl), auxcl) : new DefaultELEngine(ELExpressionFactory.newInstance());
        } else {
            LOG.warn("Expressions are not supported by Dozer. Are you missing javax.el dependency?");
            answer = new NoopELEngine();
        }
        return answer;
    }
}

