/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj.converter;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.camel.Converter;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.component.quickfixj.QuickfixjEventCategory;
import org.apache.camel.util.IOHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.ConfigError;
import quickfix.DataDictionary;
import quickfix.FieldNotFound;
import quickfix.InvalidMessage;
import quickfix.Session;
import quickfix.SessionID;

@Converter
public final class QuickfixjConverters {
    private static final Logger LOG = LoggerFactory.getLogger(QuickfixjConverters.class);

    private QuickfixjConverters() {
    }

    @Converter
    public static SessionID toSessionID(String sessionID) {
        return new SessionID(sessionID);
    }

    @Converter
    public static quickfix.Message toMessage(String value, Exchange exchange) throws InvalidMessage, ConfigError {
        DataDictionary dataDictionary = QuickfixjConverters.getDataDictionary(exchange);
        return new quickfix.Message(value, dataDictionary);
    }

    @Converter
    public static quickfix.Message toMessage(byte[] value, Exchange exchange) throws InvalidMessage, ConfigError, UnsupportedEncodingException {
        DataDictionary dataDictionary = QuickfixjConverters.getDataDictionary(exchange);
        String charsetName = IOHelper.getCharsetName((Exchange)exchange);
        String message = charsetName != null ? new String(value, charsetName) : new String(value);
        if (message.endsWith("\r\n")) {
            message = message.substring(0, message.length() - 2);
        } else if (message.endsWith("\r") || message.endsWith("\n")) {
            message = message.substring(0, message.length() - 1);
        }
        return new quickfix.Message(message, dataDictionary, false);
    }

    @Converter
    public static InputStream toInputStream(quickfix.Message value, Exchange exchange) throws InvalidMessage, ConfigError, UnsupportedEncodingException {
        if (exchange != null) {
            String charsetName = IOHelper.getCharsetName((Exchange)exchange);
            if (charsetName != null) {
                return new ByteArrayInputStream(value.toString().getBytes(charsetName));
            }
            return new ByteArrayInputStream(value.toString().getBytes());
        }
        return null;
    }

    private static DataDictionary getDataDictionary(Exchange exchange) throws ConfigError {
        Object dictionaryValue = exchange.getProperties().get("DataDictionary");
        DataDictionary dataDictionary = null;
        if (dictionaryValue instanceof DataDictionary) {
            dataDictionary = (DataDictionary)dictionaryValue;
        } else if (dictionaryValue instanceof String) {
            dataDictionary = new DataDictionary((String)dictionaryValue);
        } else {
            SessionID sessionID = (SessionID)exchange.getIn().getHeader("SessionID", SessionID.class);
            if (sessionID != null) {
                Session session = Session.lookupSession((SessionID)sessionID);
                dataDictionary = session != null ? session.getDataDictionary() : null;
            }
        }
        return dataDictionary;
    }

    public static Exchange toExchange(Endpoint endpoint, SessionID sessionID, quickfix.Message message, QuickfixjEventCategory eventCategory) {
        return QuickfixjConverters.toExchange(endpoint, sessionID, message, eventCategory, ExchangePattern.InOnly);
    }

    public static Exchange toExchange(Endpoint endpoint, SessionID sessionID, quickfix.Message message, QuickfixjEventCategory eventCategory, ExchangePattern exchangePattern) {
        Exchange exchange = endpoint.createExchange(exchangePattern);
        Message camelMessage = exchange.getIn();
        camelMessage.setHeader("EventCategory", (Object)eventCategory);
        camelMessage.setHeader("SessionID", (Object)sessionID);
        if (message != null) {
            try {
                camelMessage.setHeader("MessageType", (Object)message.getHeader().getString(35));
            }
            catch (FieldNotFound e) {
                LOG.warn("Message type field not found in QFJ message: {}, continuing...", (Object)message);
            }
        }
        camelMessage.setBody((Object)message);
        return exchange;
    }
}

