/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.NoSuchLanguageException;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.SendDynamicProcessor;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,endpoint,routing")
@XmlRootElement(name="toD")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ToDynamicDefinition
extends NoOutputDefinition<ToDynamicDefinition> {
    private static final Pattern RAW_PATTERN = Pattern.compile("RAW\\([^\\)]+\\)");
    @XmlAttribute
    @Metadata(required="true")
    private String uri;
    @XmlAttribute
    private ExchangePattern pattern;
    @XmlAttribute
    private Integer cacheSize;
    @XmlAttribute
    private Boolean ignoreInvalidEndpoint;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean allowOptimisedComponents;

    public ToDynamicDefinition() {
    }

    public ToDynamicDefinition(String uri) {
        this.uri = uri;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        ObjectHelper.notEmpty(this.uri, "uri", this);
        Expression exp = this.createExpression(routeContext);
        SendDynamicProcessor processor = new SendDynamicProcessor(this.uri, exp);
        processor.setCamelContext(routeContext.getCamelContext());
        processor.setPattern(this.pattern);
        if (this.cacheSize != null) {
            processor.setCacheSize(this.cacheSize);
        }
        if (this.ignoreInvalidEndpoint != null) {
            processor.setIgnoreInvalidEndpoint(this.ignoreInvalidEndpoint);
        }
        return processor;
    }

    protected Expression createExpression(RouteContext routeContext) {
        String[] parts;
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (String part : parts = ToDynamicDefinition.safeSplitRaw(this.uri)) {
            String value = ObjectHelper.after(part, "language:");
            if (value != null) {
                String before = ObjectHelper.before(value, ":");
                String after = ObjectHelper.after(value, ":");
                if (before != null && after != null) {
                    try {
                        Language partLanguage = routeContext.getCamelContext().resolveLanguage(before);
                        if (partLanguage != null) {
                            Expression exp = partLanguage.createExpression(after);
                            list.add(exp);
                            continue;
                        }
                    }
                    catch (NoSuchLanguageException noSuchLanguageException) {
                        // empty catch block
                    }
                }
            }
            Language lan = routeContext.getCamelContext().resolveLanguage("simple");
            Expression exp = lan.createExpression(part);
            list.add(exp);
        }
        Expression exp = list.size() == 1 ? (Expression)list.get(0) : ExpressionBuilder.concatExpression(list);
        return exp;
    }

    public String toString() {
        return "DynamicTo[" + this.getLabel() + "]";
    }

    public ToDynamicDefinition pattern(ExchangePattern pattern) {
        this.setPattern(pattern);
        return this;
    }

    public ToDynamicDefinition cacheSize(int cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public ToDynamicDefinition ignoreInvalidEndpoint() {
        this.setIgnoreInvalidEndpoint(true);
        return this;
    }

    public ToDynamicDefinition allowOptimisedComponents(boolean allowOptimisedComponents) {
        this.setAllowOptimisedComponents(allowOptimisedComponents);
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public Integer getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(Integer cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Boolean getIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(Boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public Boolean getAllowOptimisedComponents() {
        return this.allowOptimisedComponents;
    }

    public void setAllowOptimisedComponents(Boolean allowOptimisedComponents) {
        this.allowOptimisedComponents = allowOptimisedComponents;
    }

    private static List<Pair> checkRAW(String s) {
        Matcher matcher = RAW_PATTERN.matcher(s);
        ArrayList<Pair> answer = new ArrayList<Pair>();
        while (matcher.find()) {
            answer.add(new Pair(matcher.start(), matcher.end() - 1));
        }
        return answer;
    }

    private static boolean isRaw(int index, List<Pair> pairs) {
        for (Pair pair : pairs) {
            if (index < pair.left) {
                return false;
            }
            if (index < pair.left || index > pair.right) continue;
            return true;
        }
        return false;
    }

    private static String[] safeSplitRaw(String s) {
        ArrayList<String> list = new ArrayList<String>();
        if (!s.contains("+")) {
            list.add(s);
        } else {
            List<Pair> rawPairs = ToDynamicDefinition.checkRAW(s);
            StringBuilder sb = new StringBuilder();
            char[] chars = s.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (ch != '+' || ToDynamicDefinition.isRaw(i, rawPairs)) {
                    sb.append(ch);
                    continue;
                }
                list.add(sb.toString());
                sb.setLength(0);
            }
            if (sb.length() > 0) {
                list.add(sb.toString());
                sb.setLength(0);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private static class Pair {
        int left;
        int right;

        Pair(int left, int right) {
            this.left = left;
            this.right = right;
        }
    }
}

