/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.slack;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.slack.helper.SlackMessage;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONObject;

public class SlackComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public SlackComponentVerifierExtension() {
        this("slack");
    }

    public SlackComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        ResultBuilder builder = ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption((String)"webhookUrl", parameters));
        return builder.build();
    }

    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope((ComponentVerifierExtension.Result.Status)ComponentVerifierExtension.Result.Status.OK, (ComponentVerifierExtension.Scope)ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        String webhookUrl = (String)parameters.get("webhookUrl");
        try {
            CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
            HttpPost httpPost = new HttpPost(webhookUrl);
            SlackMessage slackMessage = new SlackMessage();
            slackMessage.setText("Test connection");
            String json = this.asJson(slackMessage);
            StringEntity body = new StringEntity(json);
            httpPost.setEntity((HttpEntity)body);
            HttpResponse response = client.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() > 299) {
                builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid webhookUrl").parameterKey("webhookUrl").build());
            }
        }
        catch (Exception e) {
            builder.error(ResultErrorBuilder.withCodeAndDescription((ComponentVerifierExtension.VerificationError.Code)ComponentVerifierExtension.VerificationError.StandardCode.AUTHENTICATION, (String)"Invalid webhookUrl").parameterKey("webhookUrl").build());
        }
    }

    protected String asJson(SlackMessage message) {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        jsonMap.put("text", message.getText());
        JSONObject jsonObject = new JSONObject(jsonMap);
        return JSONObject.toJSONString((Map)jsonObject);
    }
}

