/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisConfiguration;
import org.apache.camel.component.redis.RedisEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.Topic;

public class RedisConsumer
extends DefaultConsumer
implements MessageListener {
    private final RedisConfiguration redisConfiguration;

    public RedisConsumer(RedisEndpoint redisEndpoint, Processor processor, RedisConfiguration redisConfiguration) {
        super((Endpoint)redisEndpoint, processor);
        this.redisConfiguration = redisConfiguration;
    }

    protected void doStart() throws Exception {
        super.doStart();
        Collection<Topic> topics = this.toTopics(this.redisConfiguration.getChannels());
        this.redisConfiguration.getListenerContainer().addMessageListener((MessageListener)this, topics);
    }

    protected void doStop() throws Exception {
        Collection<Topic> topics = this.toTopics(this.redisConfiguration.getChannels());
        this.redisConfiguration.getListenerContainer().removeMessageListener((MessageListener)this, topics);
        super.doStop();
    }

    private Collection<Topic> toTopics(String channels) {
        String[] channelsArrays = channels.split(",");
        ArrayList<Topic> topics = new ArrayList<Topic>();
        for (String channel : channelsArrays) {
            String name = channel.trim();
            if (Command.PSUBSCRIBE.equals((Object)this.redisConfiguration.getCommand())) {
                topics.add((Topic)new PatternTopic(name));
                continue;
            }
            if (Command.SUBSCRIBE.equals((Object)this.redisConfiguration.getCommand())) {
                topics.add((Topic)new ChannelTopic(name));
                continue;
            }
            throw new IllegalArgumentException("Unsupported Command " + (Object)((Object)this.redisConfiguration.getCommand()));
        }
        return topics;
    }

    public void onMessage(Message message, byte[] pattern) {
        try {
            Exchange exchange = this.getEndpoint().createExchange();
            this.setChannel(exchange, message.getChannel());
            this.setPattern(exchange, pattern);
            this.setBody(exchange, message.getBody());
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setBody(Exchange exchange, byte[] body) {
        if (body != null) {
            exchange.getIn().setBody(this.redisConfiguration.getSerializer().deserialize(body));
        }
    }

    private void setPattern(Exchange exchange, byte[] pattern) {
        if (pattern != null) {
            exchange.getIn().setHeader("CamelRedis.Pattern", (Object)pattern);
        }
    }

    private void setChannel(Exchange exchange, byte[] message) throws UnsupportedEncodingException {
        if (message != null) {
            exchange.getIn().setHeader("CamelRedis.Channel", (Object)new String(message, "UTF8"));
        }
    }
}

