/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dns.policy;

import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.ServiceStatus;
import org.apache.camel.component.dns.policy.DnsActivation;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.support.LoggingExceptionHandler;
import org.apache.camel.support.RoutePolicySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsActivationPolicy
extends RoutePolicySupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(DnsActivationPolicy.class);
    private ExceptionHandler exceptionHandler;
    private DnsActivation dnsActivation;
    private long ttl;
    private boolean stopRoutesOnException;
    private Map<String, Route> routes = new ConcurrentHashMap<String, Route>();
    private Timer timer;

    public DnsActivationPolicy() {
        this.dnsActivation = new DnsActivation();
    }

    public void onInit(Route route) {
        LOG.debug("onInit " + route.getId());
        this.routes.put(route.getId(), route);
    }

    public void onRemove(Route route) {
        LOG.debug("onRemove " + route.getId());
    }

    public void onStart(Route route) {
        LOG.debug("onStart " + route.getId());
    }

    public void onStop(Route route) {
        LOG.debug("onStop " + route.getId());
    }

    public void onSuspend(Route route) {
        LOG.debug("onSuspend " + route.getId());
    }

    public void onResume(Route route) {
        LOG.debug("onResume " + route.getId());
    }

    public void onExchangeBegin(Route route, Exchange exchange) {
        LOG.debug("onExchange start " + route.getId() + "/" + exchange.getExchangeId());
    }

    public void onExchangeDone(Route route, Exchange exchange) {
        LOG.debug("onExchange end " + route.getId() + "/" + exchange.getExchangeId());
    }

    protected void doStart() throws Exception {
        LOG.debug("doStart");
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new DnsActivationTask(), 0L, this.ttl);
    }

    protected void doStop() throws Exception {
        LOG.debug("doStop");
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new LoggingExceptionHandler(((Object)((Object)this)).getClass());
        }
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setHostname(String hostname) {
        this.dnsActivation.setHostname(hostname);
    }

    public void setResolvesTo(List<String> resolvesTo) {
        this.dnsActivation.setResolvesTo(resolvesTo);
    }

    public void setResolvesTo(String resolvesTo) {
        this.dnsActivation.setResolvesTo(resolvesTo);
    }

    public void setTtl(String ttl) throws Exception {
        this.ttl = Long.parseLong(ttl);
    }

    public void setStopRoutesOnException(String stopRoutesOnException) throws Exception {
        this.stopRoutesOnException = Boolean.parseBoolean(stopRoutesOnException);
    }

    private void startRouteImpl(Route route) throws Exception {
        ServiceStatus routeStatus = route.getRouteContext().getCamelContext().getRouteStatus(route.getId());
        if (routeStatus == ServiceStatus.Stopped) {
            LOG.info("Starting " + route.getId());
            this.startRoute(route);
        } else if (routeStatus == ServiceStatus.Suspended) {
            LOG.info("Resuming " + route.getId());
            this.startConsumer(route.getConsumer());
        } else {
            LOG.debug("Nothing to do " + route.getId() + " is " + routeStatus);
        }
    }

    private void startRoutes() {
        for (String routeId : this.routes.keySet()) {
            try {
                Route route = this.routes.get(routeId);
                this.startRouteImpl(route);
            }
            catch (Exception e) {
                LOG.warn(routeId, (Throwable)e);
            }
        }
    }

    private void stopRouteImpl(Route route) throws Exception {
        ServiceStatus routeStatus = route.getRouteContext().getCamelContext().getRouteStatus(route.getId());
        if (routeStatus == ServiceStatus.Started) {
            LOG.info("Stopping " + route.getId());
            this.stopRoute(route);
        } else {
            LOG.debug("Nothing to do " + route.getId() + " is " + routeStatus);
        }
    }

    private void stopRoutes() {
        for (String routeId : this.routes.keySet()) {
            try {
                Route route = this.routes.get(routeId);
                this.stopRouteImpl(route);
            }
            catch (Exception e) {
                LOG.warn(routeId, (Throwable)e);
            }
        }
    }

    class DnsActivationTask
    extends TimerTask {
        DnsActivationTask() {
        }

        @Override
        public void run() {
            block4: {
                try {
                    if (DnsActivationPolicy.this.dnsActivation.isActive()) {
                        DnsActivationPolicy.this.startRoutes();
                    } else {
                        DnsActivationPolicy.this.stopRoutes();
                    }
                }
                catch (Exception e) {
                    LOG.warn("DnsActivation TimerTask failed", (Throwable)e);
                    if (!DnsActivationPolicy.this.stopRoutesOnException) break block4;
                    DnsActivationPolicy.this.stopRoutes();
                }
            }
        }
    }
}

