/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.jbpm.JBPMConfiguration;
import org.apache.camel.component.jbpm.JBPMEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ExchangeHelper;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.manager.RuntimeEngine;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.api.task.TaskService;
import org.kie.api.task.model.Attachment;
import org.kie.api.task.model.Content;
import org.kie.api.task.model.OrganizationalEntity;
import org.kie.api.task.model.Status;
import org.kie.api.task.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPMProducer
extends DefaultProducer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(JBPMProducer.class);
    private KieSession kieSession;
    private TaskService taskService;
    private JBPMConfiguration configuration;
    private RuntimeEngine runtimeEngine;

    public JBPMProducer(JBPMEndpoint endpoint, RuntimeEngine runtimeEngine) {
        super((Endpoint)endpoint);
        this.configuration = endpoint.getConfiguration();
        this.runtimeEngine = runtimeEngine;
    }

    protected void doStart() throws Exception {
        LOGGER.trace("starting producer");
        this.kieSession = this.runtimeEngine.getKieSession();
        this.taskService = this.runtimeEngine.getTaskService();
        super.doStart();
        LOGGER.trace("started producer");
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.kieSession != null) {
            this.kieSession = null;
        }
        if (this.taskService != null) {
            this.taskService = null;
        }
    }

    public void process(Exchange exchange) throws Exception {
        this.getOperation(exchange).execute(this.kieSession, this.taskService, this.configuration, exchange);
    }

    Operation getOperation(Exchange exchange) {
        String operation = (String)exchange.getIn().getHeader("CamelJBPMOperation", String.class);
        if (operation == null && this.configuration.getOperation() != null) {
            operation = "CamelJBPMOperation" + this.configuration.getOperation();
        }
        if (operation == null) {
            operation = "CamelJBPMOperation" + (Object)((Object)Operation.startProcess);
        }
        LOGGER.trace("Operation: [{}]", (Object)operation);
        return Operation.valueOf(operation.substring("CamelJBPMOperation".length()));
    }

    static enum Operation {
        startProcess{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                ProcessInstance processInstance = kieSession.startProcess(this.getProcessId(configuration, exchange), this.getParameters(configuration, exchange));
                this.setResult(exchange, processInstance);
            }
        }
        ,
        abortProcessInstance{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                kieSession.abortProcessInstance(this.safe(this.getProcessInstanceId(configuration, exchange)));
            }
        }
        ,
        signalEvent{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Long processInstanceId = this.getProcessInstanceId(configuration, exchange);
                if (processInstanceId != null) {
                    kieSession.signalEvent(this.getEventType(configuration, exchange), this.getEvent(configuration, exchange), processInstanceId.longValue());
                } else {
                    kieSession.signalEvent(this.getEventType(configuration, exchange), this.getEvent(configuration, exchange));
                }
            }
        }
        ,
        getProcessInstance{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                ProcessInstance processInstance = kieSession.getProcessInstance(this.safe(this.getProcessInstanceId(configuration, exchange)));
                this.setResult(exchange, processInstance);
            }
        }
        ,
        getProcessInstances{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Collection processInstances = kieSession.getProcessInstances();
                this.setResult(exchange, processInstances);
            }
        }
        ,
        fireAllRules{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Integer max = this.getMaxNumber(configuration, exchange);
                int rulesFired = max != null ? kieSession.fireAllRules(max.intValue()) : kieSession.fireAllRules();
                this.setResult(exchange, rulesFired);
            }
        }
        ,
        getFactCount{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                long factCount = kieSession.getFactCount();
                this.setResult(exchange, factCount);
            }
        }
        ,
        getGlobal{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Object global = kieSession.getGlobal(this.getIdentifier(configuration, exchange));
                this.setResult(exchange, global);
            }
        }
        ,
        setGlobal{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                kieSession.setGlobal(this.getIdentifier(configuration, exchange), this.getValue(configuration, exchange));
            }
        }
        ,
        abortWorkItem{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                kieSession.getWorkItemManager().abortWorkItem(this.safe(this.getWorkItemId(configuration, exchange)));
            }
        }
        ,
        completeWorkItem{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                kieSession.getWorkItemManager().completeWorkItem(this.safe(this.getWorkItemId(configuration, exchange)), this.getParameters(configuration, exchange));
            }
        }
        ,
        activateTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.activate(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        }
        ,
        addTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                long taskId = taskService.addTask(this.getTask(configuration, exchange), this.getParameters(configuration, exchange));
                this.setResult(exchange, taskId);
            }
        }
        ,
        claimNextAvailableTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.claimNextAvailable(this.getUserId(configuration, exchange), this.getLanguage(configuration, exchange));
            }
        }
        ,
        claimTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.claim(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        }
        ,
        completeTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.complete(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange), this.getParameters(configuration, exchange));
            }
        }
        ,
        delegateTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.delegate(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange), this.getTargetUserId(configuration, exchange));
            }
        }
        ,
        exitTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.exit(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        }
        ,
        failTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.fail(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange), this.getParameters(configuration, exchange));
            }
        }
        ,
        getAttachment{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Attachment attachment = taskService.getAttachmentById(this.safe(this.getAttachmentId(configuration, exchange)));
                this.setResult(exchange, attachment);
            }
        }
        ,
        getContent{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Content content = taskService.getContentById(this.safe(this.getContentId(configuration, exchange)));
                this.setResult(exchange, content);
            }
        }
        ,
        getTasksAssignedAsBusinessAdministrator{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                List taskSummaries = taskService.getTasksAssignedAsBusinessAdministrator(this.getUserId(configuration, exchange), this.getLanguage(configuration, exchange));
                this.setResult(exchange, taskSummaries);
            }
        }
        ,
        getTasksAssignedAsPotentialOwnerByStatus{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.getTasksAssignedAsPotentialOwnerByStatus(this.getUserId(configuration, exchange), this.getStatuses(configuration, exchange), this.getLanguage(configuration, exchange));
            }
        }
        ,
        getTaskByWorkItem{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Task task = taskService.getTaskByWorkItemId(this.safe(this.getWorkItemId(configuration, exchange)));
                this.setResult(exchange, task);
            }
        }
        ,
        getTaskBy{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Task task = taskService.getTaskById(this.safe(this.getTaskId(configuration, exchange)));
                this.setResult(exchange, task);
            }
        }
        ,
        getTaskContent{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                Map taskContent = taskService.getTaskContent(this.safe(this.getTaskId(configuration, exchange)));
                this.setResult(exchange, taskContent);
            }
        }
        ,
        getTasksByProcessInstance{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                List processInstanceIds = taskService.getTasksByProcessInstanceId(this.safe(this.getProcessInstanceId(configuration, exchange)));
                this.setResult(exchange, processInstanceIds);
            }
        }
        ,
        getTasksByStatusByProcessInstance{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                List taskSummaryList = taskService.getTasksByStatusByProcessInstanceId(this.safe(this.getProcessInstanceId(configuration, exchange)), this.getStatuses(configuration, exchange), this.getLanguage(configuration, exchange));
                this.setResult(exchange, taskSummaryList);
            }
        }
        ,
        getTasksOwned{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                List summaryList = taskService.getTasksOwned(this.getUserId(configuration, exchange), this.getLanguage(configuration, exchange));
                this.setResult(exchange, summaryList);
            }
        }
        ,
        nominateTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.nominate(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange), this.getEntities(configuration, exchange));
            }
        }
        ,
        releaseTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.release(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        }
        ,
        resumeTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.resume(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        }
        ,
        skipTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.skip(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        }
        ,
        startTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.start(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        }
        ,
        stopTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.stop(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        }
        ,
        suspendTask{

            @Override
            void execute(KieSession kieSession, TaskService taskService, JBPMConfiguration configuration, Exchange exchange) {
                taskService.suspend(this.safe(this.getTaskId(configuration, exchange)), this.getUserId(configuration, exchange));
            }
        };


        List<Status> getStatuses(JBPMConfiguration configuration, Exchange exchange) {
            List<Status> statusList = (List<Status>)exchange.getIn().getHeader("CamelJBPMStatusList", List.class);
            if (statusList == null) {
                statusList = configuration.getStatuses();
            }
            return statusList;
        }

        List<OrganizationalEntity> getEntities(JBPMConfiguration configuration, Exchange exchange) {
            List<OrganizationalEntity> entityList = (List<OrganizationalEntity>)exchange.getIn().getHeader("CamelJBPMEntityList", List.class);
            if (entityList == null) {
                entityList = configuration.getEntities();
            }
            return entityList;
        }

        Long getAttachmentId(JBPMConfiguration configuration, Exchange exchange) {
            Long attachmentId = (Long)exchange.getIn().getHeader("CamelJBPMAttachmentId", Long.class);
            if (attachmentId == null) {
                attachmentId = configuration.getAttachmentId();
            }
            return attachmentId;
        }

        Long getContentId(JBPMConfiguration configuration, Exchange exchange) {
            Long contentId = (Long)exchange.getIn().getHeader("CamelJBPMContentId", Long.class);
            if (contentId == null) {
                contentId = configuration.getContentId();
            }
            return contentId;
        }

        String getTargetUserId(JBPMConfiguration configuration, Exchange exchange) {
            String userId = (String)exchange.getIn().getHeader("CamelJBPMTargetUserId", String.class);
            if (userId == null) {
                userId = configuration.getTargetUserId();
            }
            return userId;
        }

        String getLanguage(JBPMConfiguration configuration, Exchange exchange) {
            String language = (String)exchange.getIn().getHeader("CamelJBPMLanguage", String.class);
            if (language == null) {
                language = configuration.getLanguage();
            }
            return language;
        }

        Task getTask(JBPMConfiguration configuration, Exchange exchange) {
            Task task = (Task)exchange.getIn().getHeader("CamelJBPMTask", Task.class);
            if (task == null) {
                task = configuration.getTask();
            }
            return task;
        }

        String getUserId(JBPMConfiguration configuration, Exchange exchange) {
            String userId = (String)exchange.getIn().getHeader("CamelJBPMUserId", String.class);
            if (userId == null) {
                userId = configuration.getUserId();
            }
            return userId;
        }

        Long getTaskId(JBPMConfiguration configuration, Exchange exchange) {
            Long taskId = (Long)exchange.getIn().getHeader("CamelJBPMTaskId", Long.class);
            if (taskId == null) {
                taskId = configuration.getTaskId();
            }
            return taskId;
        }

        Long getWorkItemId(JBPMConfiguration configuration, Exchange exchange) {
            Long workItemId = (Long)exchange.getIn().getHeader("CamelJBPMWorkItemId", Long.class);
            if (workItemId == null) {
                workItemId = configuration.getWorkItemId();
            }
            return workItemId;
        }

        String getIdentifier(JBPMConfiguration configuration, Exchange exchange) {
            String identifier = (String)exchange.getIn().getHeader("CamelJBPMIdentifier", String.class);
            if (identifier == null) {
                identifier = configuration.getIdentifier();
            }
            return identifier;
        }

        Integer getMaxNumber(JBPMConfiguration configuration, Exchange exchange) {
            Integer max = (Integer)exchange.getIn().getHeader("CamelJBPMMaxNumber", Integer.class);
            if (max == null) {
                max = configuration.getMaxNumber();
            }
            return max;
        }

        Object getEvent(JBPMConfiguration configuration, Exchange exchange) {
            Object event = exchange.getIn().getHeader("CamelJBPMEvent");
            if (event == null) {
                event = configuration.getEvent();
            }
            return event;
        }

        String getEventType(JBPMConfiguration configuration, Exchange exchange) {
            String eventType = (String)exchange.getIn().getHeader("CamelJBPMEventType", String.class);
            if (eventType == null) {
                eventType = configuration.getEventType();
            }
            return eventType;
        }

        String getProcessId(JBPMConfiguration configuration, Exchange exchange) {
            String processId = (String)exchange.getIn().getHeader("CamelJBPMProcessId", String.class);
            if (processId == null) {
                processId = configuration.getProcessId();
            }
            return processId;
        }

        Long getProcessInstanceId(JBPMConfiguration configuration, Exchange exchange) {
            Long processInstanceId = (Long)exchange.getIn().getHeader("CamelJBPMProcessInstanceId", Long.class);
            if (processInstanceId == null) {
                processInstanceId = configuration.getProcessInstanceId();
            }
            return processInstanceId;
        }

        Map<String, Object> getParameters(JBPMConfiguration configuration, Exchange exchange) {
            Map<String, Object> parameters = (Map<String, Object>)exchange.getIn().getHeader("CamelJBPMParameters", Map.class);
            if (parameters == null) {
                parameters = configuration.getParameters();
            }
            return parameters;
        }

        Object getValue(JBPMConfiguration configuration, Exchange exchange) {
            Object value = exchange.getIn().getHeader("CamelJBPMValue");
            if (value == null) {
                value = configuration.getValue();
            }
            return value;
        }

        Message getResultMessage(Exchange exchange) {
            return ExchangeHelper.isOutCapable((Exchange)exchange) ? exchange.getOut() : exchange.getIn();
        }

        long safe(Long aLong) {
            return aLong != null ? aLong : 0L;
        }

        void setResult(Exchange exchange, Object result) {
            this.getResultMessage(exchange).setBody(result);
        }

        abstract void execute(KieSession var1, TaskService var2, JBPMConfiguration var3, Exchange var4);
    }
}

