/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ibatis.strategy;

import com.ibatis.sqlmap.client.SqlMapClient;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.ibatis.IBatisConsumer;
import org.apache.camel.component.ibatis.IBatisEndpoint;
import org.apache.camel.component.ibatis.strategy.IBatisProcessingStrategy;

public class DefaultIBatisProcessingStategy
implements IBatisProcessingStrategy {
    private int isolation = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(IBatisEndpoint endpoint, Exchange exchange, Object data, String consumeStatements) throws Exception {
        SqlMapClient client = endpoint.getSqlMapClient();
        boolean useTrans = endpoint.isUseTransactions();
        String[] statements = consumeStatements.split(",");
        try {
            if (useTrans) {
                client.startTransaction(this.isolation);
            }
            for (String statement : statements) {
                client.update(statement.trim(), data);
            }
            if (useTrans) {
                client.commitTransaction();
            }
        }
        finally {
            if (useTrans) {
                client.endTransaction();
            }
        }
    }

    @Override
    public List<Object> poll(IBatisConsumer consumer, IBatisEndpoint endpoint) throws Exception {
        SqlMapClient client = endpoint.getSqlMapClient();
        return client.queryForList(endpoint.getStatement(), null);
    }

    @Override
    public int getIsolation() {
        return this.isolation;
    }

    @Override
    public void setIsolation(int isolation) {
        this.isolation = isolation;
    }
}

