/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.commands;

import java.io.PrintStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.camel.commands.AbstractCamelCommand;
import org.apache.camel.commands.CamelController;
import org.apache.camel.util.JsonSchemaHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;

public class EndpointListCommand
extends AbstractCamelCommand {
    private static final String URI_COLUMN_LABEL = "Uri";
    private static final String STATUS_COLUMN_LABEL = "Status";
    private static final String CONTEXT_NAME_COLUMN_LABEL = "Context";
    private static final int DEFAULT_COLUMN_WIDTH_INCREMENT = 0;
    private static final String DEFAULT_FIELD_PREAMBLE = " ";
    private static final String DEFAULT_FIELD_POSTAMBLE = " ";
    private static final String DEFAULT_HEADER_PREAMBLE = " ";
    private static final String DEFAULT_HEADER_POSTAMBLE = " ";
    private static final int DEFAULT_FORMAT_BUFFER_LENGTH = 24;
    private static final int MAX_COLUMN_WIDTH = 120;
    private static final int MIN_COLUMN_WIDTH = 12;
    boolean decode = true;
    boolean verbose;
    boolean explain;
    private final String context;

    public EndpointListCommand(String context, boolean decode, boolean verbose, boolean explain) {
        this.decode = decode;
        this.verbose = verbose;
        this.explain = explain;
        this.context = context;
    }

    @Override
    public Object execute(CamelController camelController, PrintStream out, PrintStream err) throws Exception {
        List<Map<String, String>> camelContextInfos = camelController.getCamelContexts(this.context);
        HashMap<String, List<Map<String, String>>> contextsToEndpoints = new HashMap<String, List<Map<String, String>>>();
        for (Map<String, String> camelContextInfo : camelContextInfos) {
            String camelContextName = camelContextInfo.get("name");
            List<Map<String, String>> endpoints = camelController.getEndpoints(camelContextName);
            if (endpoints.isEmpty()) continue;
            contextsToEndpoints.put(camelContextName, endpoints);
        }
        Map<String, Integer> columnWidths = this.computeColumnWidths(contextsToEndpoints);
        String headerFormat = this.buildFormatString(columnWidths, true);
        String rowFormat = this.buildFormatString(columnWidths, false);
        for (Map.Entry stringListEntry : contextsToEndpoints.entrySet()) {
            String camelContextName = (String)stringListEntry.getKey();
            List endpoints = (List)stringListEntry.getValue();
            out.println(String.format(headerFormat, CONTEXT_NAME_COLUMN_LABEL, URI_COLUMN_LABEL, STATUS_COLUMN_LABEL));
            out.println(String.format(headerFormat, "-------", "---", "------"));
            for (Map row : endpoints) {
                String uri = (String)row.get("uri");
                if (this.decode) {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                uri = URISupport.sanitizeUri((String)uri);
                String state = (String)row.get("state");
                out.println(String.format(rowFormat, camelContextName, uri, state));
                if (!this.explain) continue;
                boolean first = true;
                String json = camelController.explainEndpointAsJSon(camelContextName, (String)row.get("uri"), this.verbose);
                List options = JsonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
                for (Map option : options) {
                    String key = (String)option.get("name");
                    String kind = (String)option.get("kind");
                    String type = (String)option.get("type");
                    String javaType = (String)option.get("javaType");
                    String value = (String)option.get("value");
                    if (ObjectHelper.isEmpty((Object)value)) {
                        value = (String)option.get("defaultValue");
                    }
                    String desc = (String)option.get("description");
                    if (key == null || value == null) continue;
                    if (first) {
                        out.println();
                        first = false;
                    }
                    String line = "path".equals(kind) ? "\t" + key + " (endpoint path) = " + value : "\t" + key + " = " + value;
                    out.println(line);
                    if (type != null) {
                        String displayType = type;
                        if (javaType != null && !displayType.equals(javaType)) {
                            displayType = type + " (" + javaType + ")";
                        }
                        out.println("\t" + displayType);
                    }
                    if (desc != null) {
                        out.println("\t" + desc);
                    }
                    out.println();
                }
            }
        }
        return null;
    }

    private Map<String, Integer> computeColumnWidths(Map<String, List<Map<String, String>>> contextsToEndpoints) throws Exception {
        int maxUriLen = 0;
        int maxStatusLen = 0;
        int maxCamelContextLen = 0;
        for (Map.Entry<String, List<Map<String, String>>> stringListEntry : contextsToEndpoints.entrySet()) {
            String camelContextName = stringListEntry.getKey();
            maxCamelContextLen = Math.max(maxCamelContextLen, camelContextName.length());
            List<Map<String, String>> endpoints = stringListEntry.getValue();
            for (Map<String, String> row : endpoints) {
                String uri = row.get("uri");
                if (this.decode) {
                    uri = URLDecoder.decode(uri, "UTF-8");
                }
                maxUriLen = Math.max(maxUriLen, (uri = URISupport.sanitizeUri((String)uri)) == null ? 0 : uri.length());
                String status = row.get("state");
                maxStatusLen = Math.max(maxStatusLen, status == null ? 0 : status.length());
            }
        }
        Hashtable<String, Integer> retval = new Hashtable<String, Integer>();
        retval.put(URI_COLUMN_LABEL, maxUriLen);
        retval.put(STATUS_COLUMN_LABEL, maxStatusLen);
        retval.put(CONTEXT_NAME_COLUMN_LABEL, maxCamelContextLen);
        return retval;
    }

    private String buildFormatString(Map<String, Integer> columnWidths, boolean isHeader) {
        String fieldPostamble;
        String fieldPreamble;
        if (isHeader) {
            fieldPreamble = " ";
            fieldPostamble = " ";
        } else {
            fieldPreamble = " ";
            fieldPostamble = " ";
        }
        int columnWidthIncrement = 0;
        int uriLen = Math.min(columnWidths.get(URI_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        uriLen = Math.max(12, uriLen);
        int ctxLen = Math.min(columnWidths.get(CONTEXT_NAME_COLUMN_LABEL) + columnWidthIncrement, this.getMaxColumnWidth());
        ctxLen = Math.max(12, ctxLen);
        StringBuilder retval = new StringBuilder(24);
        retval.append(fieldPreamble).append("%-").append(ctxLen).append('.').append(ctxLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%-").append(uriLen).append('.').append(uriLen).append('s').append(fieldPostamble).append(' ');
        retval.append(fieldPreamble).append("%s").append(fieldPostamble).append(' ');
        return retval.toString();
    }

    private int getMaxColumnWidth() {
        if (this.verbose) {
            return Integer.MAX_VALUE;
        }
        return 120;
    }
}

