/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.xray;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Entity;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceID;
import com.amazonaws.xray.exceptions.AlreadyEmittedException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.StaticService;
import org.apache.camel.component.aws.xray.NoopTracingStrategy;
import org.apache.camel.component.aws.xray.SegmentDecorator;
import org.apache.camel.management.event.ExchangeSendingEvent;
import org.apache.camel.management.event.ExchangeSentEvent;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.RoutePolicy;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.RoutePolicySupport;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XRayTracer
extends ServiceSupport
implements RoutePolicyFactory,
StaticService,
CamelContextAware {
    public static final String XRAY_TRACE_ID = "Camel-AWS-XRay-Trace-ID";
    public static final String XRAY_TRACE_ENTITY = "Camel-AWS-XRay-Trace-Entity";
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Map<String, SegmentDecorator> decorators = new HashMap<String, SegmentDecorator>();
    private static final String CURRENT_SEGMENT = "CAMEL_PROPERTY_AWS_XRAY_CURRENT_SEGMENT";
    private final XRayEventNotifier eventNotifier = new XRayEventNotifier();
    private CamelContext camelContext;
    private Set<String> excludePatterns = new HashSet<String>();
    private InterceptStrategy tracingStrategy;

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public RoutePolicy createRoutePolicy(CamelContext camelContext, String routeId, RouteDefinition route) {
        this.init(camelContext);
        return new XRayRoutePolicy(routeId);
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)((Object)this));
        this.camelContext.getManagementStrategy().addEventNotifier((EventNotifier)this.eventNotifier);
        if (!this.camelContext.getRoutePolicyFactories().contains((Object)this)) {
            this.camelContext.addRoutePolicyFactory((RoutePolicyFactory)this);
        }
        if (null == this.tracingStrategy) {
            LOG.info("No tracing strategy available. Defaulting to no-op strategy");
            this.tracingStrategy = new NoopTracingStrategy();
        }
        this.camelContext.addInterceptStrategy(this.tracingStrategy);
        LOG.debug("Starting XRay tracer");
    }

    protected void doStop() throws Exception {
        this.camelContext.getManagementStrategy().removeEventNotifier((EventNotifier)this.eventNotifier);
        ServiceHelper.stopAndShutdownService((Object)((Object)this.eventNotifier));
        this.camelContext.getRoutePolicyFactories().remove((Object)this);
        LOG.debug("XRay tracer stopped");
    }

    public void init(CamelContext camelContext) {
        if (!camelContext.hasService((Object)this)) {
            try {
                LOG.debug("Initializing XRay tracer");
                camelContext.addService((Object)this, true, true);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
            }
        }
    }

    public InterceptStrategy getTracingStrategy() {
        return this.tracingStrategy;
    }

    public void setTracingStrategy(InterceptStrategy tracingStrategy) {
        this.tracingStrategy = tracingStrategy;
    }

    public Set<String> getExcludePatterns() {
        return this.excludePatterns;
    }

    public void setExcludePatterns(Set<String> excludePatterns) {
        this.excludePatterns = excludePatterns;
    }

    public void addExcludePattern(String pattern) {
        this.excludePatterns.add(pattern);
    }

    private boolean isExcluded(String routeId) {
        if (!this.excludePatterns.isEmpty()) {
            for (String pattern : this.excludePatterns) {
                if (!pattern.equals(routeId)) continue;
                LOG.debug("Ignoring route with ID {}", (Object)routeId);
                return true;
            }
        }
        return false;
    }

    protected SegmentDecorator getSegmentDecorator(Endpoint endpoint) {
        SegmentDecorator sd = decorators.get(URI.create(endpoint.getEndpointUri()).getScheme());
        if (null == sd) {
            return SegmentDecorator.DEFAULT;
        }
        return sd;
    }

    public static String sanitizeName(String name) {
        return name.replaceAll("[^\\w.:/%&#=+\\-@]", "_");
    }

    static {
        ServiceLoader.load(SegmentDecorator.class).forEach(d -> {
            SegmentDecorator existing = decorators.get(d.getComponent());
            if (existing == null || existing.getClass().isInstance(d)) {
                LOG.trace("Adding segment decorator {}", (Object)d.getComponent());
                decorators.put(d.getComponent(), (SegmentDecorator)d);
            }
        });
    }

    private final class XRayRoutePolicy
    extends RoutePolicySupport {
        private String routeId;

        XRayRoutePolicy(String routeId) {
            this.routeId = routeId;
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            TraceID traceID;
            if (XRayTracer.this.isExcluded(route.getId())) {
                return;
            }
            LOG.trace("=> RoutePolicy-Begin: Route: {} - RouteId: {}", (Object)this.routeId, (Object)route.getId());
            if (exchange.getIn().getHeaders().containsKey(XRayTracer.XRAY_TRACE_ID)) {
                traceID = TraceID.fromString((String)((String)exchange.getIn().getHeader(XRayTracer.XRAY_TRACE_ID, String.class)));
            } else {
                traceID = new TraceID();
                exchange.getIn().setHeader(XRayTracer.XRAY_TRACE_ID, (Object)traceID.toString());
            }
            Entity entity = null;
            if (exchange.getIn().getHeaders().containsKey(XRayTracer.XRAY_TRACE_ENTITY)) {
                entity = (Entity)exchange.getIn().getHeader(XRayTracer.XRAY_TRACE_ENTITY, Entity.class);
            }
            if (null != entity) {
                AWSXRayRecorder recorder = AWSXRay.getGlobalRecorder();
                recorder.setTraceEntity(entity);
            }
            SegmentDecorator sd = XRayTracer.this.getSegmentDecorator(route.getEndpoint());
            Optional curSegment = AWSXRay.getCurrentSegmentOptional();
            if (!curSegment.isPresent()) {
                Segment segment = AWSXRay.beginSegment((String)XRayTracer.sanitizeName(route.getId()));
                segment.setTraceId(traceID);
                sd.pre((Entity)segment, exchange, route.getEndpoint());
                LOG.trace("Created new XRay segment {} with name {}", (Object)segment.getId(), (Object)segment.getName());
                exchange.setProperty(XRayTracer.CURRENT_SEGMENT, (Object)segment);
            } else {
                String segmentName = ((Segment)curSegment.get()).getId();
                try {
                    Subsegment subsegment = AWSXRay.beginSubsegment((String)route.getId());
                    sd.pre((Entity)subsegment, exchange, route.getEndpoint());
                    LOG.trace("Created new XRay subsegment {} with name {}", (Object)subsegment.getId(), (Object)subsegment.getName());
                }
                catch (AlreadyEmittedException aeEx) {
                    LOG.warn("Ignoring opening of subsegment " + route.getId() + " as its parent segment " + segmentName + " was already emitted before.");
                }
            }
        }

        public void onExchangeDone(Route route, Exchange exchange) {
            if (XRayTracer.this.isExcluded(route.getId())) {
                return;
            }
            LOG.trace("=> RoutePolicy-Done: Route: {} - RouteId: {}", (Object)this.routeId, (Object)route.getId());
            try {
                SegmentDecorator sd = XRayTracer.this.getSegmentDecorator(route.getEndpoint());
                Optional curSegment = AWSXRay.getCurrentSegmentOptional();
                Optional curSubSegment = AWSXRay.getCurrentSubsegmentOptional();
                if (curSubSegment.isPresent()) {
                    Subsegment subsegment = (Subsegment)curSubSegment.get();
                    sd.post((Entity)subsegment, exchange, route.getEndpoint());
                    subsegment.close();
                    LOG.trace("Closing down Subsegment {} with name {}", (Object)subsegment.getId(), (Object)subsegment.getName());
                } else if (curSegment.isPresent()) {
                    Segment segment = (Segment)curSegment.get();
                    sd.post((Entity)segment, exchange, route.getEndpoint());
                    segment.close();
                    LOG.trace("Closing down Segment {} with name {}", (Object)segment.getId(), (Object)segment.getName());
                }
            }
            catch (AlreadyEmittedException aeEx) {
                LOG.warn("Ignoring closing of (sub)segment " + route.getId() + " as the segment was already emitted.");
            }
        }

        public String toString() {
            return "XRayRoutePolicy";
        }
    }

    private final class XRayEventNotifier
    extends EventNotifierSupport {
        private XRayEventNotifier() {
        }

        public void notify(EventObject event) throws Exception {
            if (event instanceof ExchangeSendingEvent) {
                SegmentDecorator sd;
                ExchangeSendingEvent ese = (ExchangeSendingEvent)event;
                LOG.trace("-> {} - target: {} (routeId: {})", new Object[]{event.getClass().getSimpleName(), ese.getEndpoint(), ese.getExchange().getFromRouteId()});
                if (Thread.currentThread().getName().contains("Multicast")) {
                    Segment segment = (Segment)ese.getExchange().getProperty(XRayTracer.CURRENT_SEGMENT);
                    LOG.trace("Copying over segment {}/{} from exchange received from {} to exchange processing {}", new Object[]{segment.getId(), segment.getName(), ese.getExchange().getFromEndpoint(), ese.getEndpoint()});
                    AWSXRay.setTraceEntity((Entity)segment);
                }
                if (!(sd = XRayTracer.this.getSegmentDecorator(ese.getEndpoint())).newSegment()) {
                    return;
                }
                if (AWSXRay.getCurrentSegmentOptional().isPresent()) {
                    String name = sd.getOperationName(ese.getExchange(), ese.getEndpoint());
                    if (sd.getComponent() != null) {
                        name = sd.getComponent() + ":" + name;
                    }
                    try {
                        Subsegment subsegment = AWSXRay.beginSubsegment((String)XRayTracer.sanitizeName(name));
                        sd.pre((Entity)subsegment, ese.getExchange(), ese.getEndpoint());
                        LOG.trace("Creating new subsegment with ID {} and name {}", (Object)subsegment.getId(), (Object)subsegment.getName());
                    }
                    catch (AlreadyEmittedException aeEx) {
                        LOG.warn("Ignoring starting of subsegment " + name + " as its parent segment was already emitted to AWS.");
                    }
                } else {
                    LOG.trace("Ignoring creation of XRay subsegment as no segment exists in the current thread");
                }
            } else if (event instanceof ExchangeSentEvent) {
                ExchangeSentEvent ese = (ExchangeSentEvent)event;
                LOG.trace("-> {} - target: {} (routeId: {})", new Object[]{event.getClass().getSimpleName(), ese.getEndpoint(), ese.getExchange().getFromRouteId()});
                SegmentDecorator sd = XRayTracer.this.getSegmentDecorator(ese.getEndpoint());
                if (AWSXRay.getCurrentSubsegmentOptional().isPresent()) {
                    String name = sd.getOperationName(ese.getExchange(), ese.getEndpoint());
                    try {
                        Subsegment subsegment = AWSXRay.getCurrentSubsegment();
                        sd.post((Entity)subsegment, ese.getExchange(), ese.getEndpoint());
                        subsegment.close();
                        LOG.trace("Closing down subsegment with ID {} and name {}", (Object)subsegment.getId(), (Object)subsegment.getName());
                    }
                    catch (AlreadyEmittedException aeEx) {
                        LOG.warn("Ignoring close of subsegment " + name + " as its parent segment was already emitted to AWS");
                    }
                }
            } else {
                LOG.trace("Received event {} from source {}", (Object)event, event.getSource());
            }
        }

        public boolean isEnabled(EventObject event) {
            return event instanceof ExchangeSendingEvent || event instanceof ExchangeSentEvent;
        }

        public String toString() {
            return "XRayEventNotifier";
        }
    }
}

