/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mybatis;

import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.RollbackExchangeException;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.component.mybatis.MyBatisEndpoint;
import org.apache.camel.impl.ScheduledBatchPollingConsumer;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyBatisConsumer
extends ScheduledBatchPollingConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(MyBatisConsumer.class);
    protected volatile ShutdownRunningTask shutdownRunningTask;
    protected volatile int pendingExchanges;
    private String onConsume;
    private boolean useIterator = true;
    private boolean routeEmptyResultSet;

    public MyBatisConsumer(MyBatisEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public MyBatisEndpoint getEndpoint() {
        return (MyBatisEndpoint)super.getEndpoint();
    }

    protected int poll() throws Exception {
        this.shutdownRunningTask = null;
        this.pendingExchanges = 0;
        MyBatisEndpoint endpoint = this.getEndpoint();
        LOG.trace("Polling: {}", (Object)endpoint);
        List<?> data = endpoint.getProcessingStrategy().poll(this, this.getEndpoint());
        LinkedList<DataHolder> answer = new LinkedList<DataHolder>();
        if (this.useIterator) {
            for (Object item : data) {
                Exchange exchange = this.createExchange(item);
                DataHolder holder = new DataHolder();
                holder.exchange = exchange;
                holder.data = item;
                answer.add(holder);
            }
        } else if (!data.isEmpty() || this.routeEmptyResultSet) {
            Exchange exchange = this.createExchange(data);
            DataHolder holder = new DataHolder();
            holder.exchange = exchange;
            holder.data = data;
            answer.add(holder);
        }
        return this.processBatch(CastUtils.cast(answer));
    }

    public int processBatch(Queue<Object> exchanges) throws Exception {
        MyBatisEndpoint endpoint = this.getEndpoint();
        int total = exchanges.size();
        if (this.maxMessagesPerPoll > 0 && total > this.maxMessagesPerPoll) {
            LOG.debug("Limiting to maximum messages to poll " + this.maxMessagesPerPoll + " as there were " + total + " messages in this poll.");
            total = this.maxMessagesPerPoll;
        }
        for (int index = 0; index < total && this.isBatchAllowed(); ++index) {
            DataHolder holder = (DataHolder)ObjectHelper.cast(DataHolder.class, (Object)exchanges.poll());
            Exchange exchange = holder.exchange;
            Object data = holder.data;
            exchange.setProperty("CamelBatchIndex", (Object)index);
            exchange.setProperty("CamelBatchSize", (Object)total);
            exchange.setProperty("CamelBatchComplete", (Object)(index == total - 1 ? 1 : 0));
            this.pendingExchanges = total - index - 1;
            LOG.debug("Processing exchange: {} with properties: {}", (Object)exchange, (Object)exchange.getProperties());
            this.getProcessor().process(exchange);
            try {
                if (this.onConsume != null) {
                    endpoint.getProcessingStrategy().commit(endpoint, exchange, data, this.onConsume);
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
            if (!this.getEndpoint().isTransacted() || !exchange.isFailed()) continue;
            Exception cause = exchange.getException();
            if (cause != null) {
                throw cause;
            }
            throw new RollbackExchangeException("Rollback transaction due error processing exchange", exchange);
        }
        return total;
    }

    private Exchange createExchange(Object data) {
        MyBatisEndpoint endpoint = this.getEndpoint();
        Exchange exchange = endpoint.createExchange(ExchangePattern.InOnly);
        String outputHeader = this.getEndpoint().getOutputHeader();
        Message msg = exchange.getIn();
        if (outputHeader != null) {
            msg.setHeader(outputHeader, data);
        } else {
            msg.setBody(data);
        }
        msg.setHeader("CamelMyBatisStatementName", (Object)endpoint.getStatement());
        return exchange;
    }

    public String getOnConsume() {
        return this.onConsume;
    }

    public void setOnConsume(String onConsume) {
        this.onConsume = onConsume;
    }

    public boolean isUseIterator() {
        return this.useIterator;
    }

    public void setUseIterator(boolean useIterator) {
        this.useIterator = useIterator;
    }

    public boolean isRouteEmptyResultSet() {
        return this.routeEmptyResultSet;
    }

    public void setRouteEmptyResultSet(boolean routeEmptyResultSet) {
        this.routeEmptyResultSet = routeEmptyResultSet;
    }

    static final class DataHolder {
        Exchange exchange;
        Object data;

        DataHolder() {
        }
    }
}

