/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public final class ElasticsearchActionRequestConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchActionRequestConverter.class);
    private static final String ES_QUERY_DSL_PREFIX = "query";
    private static final String PARENT = "parent";

    private ElasticsearchActionRequestConverter() {
    }

    private static UpdateRequest createUpdateRequest(Object document, Exchange exchange) {
        if (document instanceof UpdateRequest) {
            return (UpdateRequest)document;
        }
        UpdateRequest updateRequest = new UpdateRequest();
        if (document instanceof byte[]) {
            updateRequest.doc(new Object[]{(byte[])document});
        } else if (document instanceof Map) {
            updateRequest.doc((Map)document);
        } else if (document instanceof String) {
            updateRequest.doc(new Object[]{(String)document, XContentFactory.xContent((CharSequence)((String)document))});
        } else if (document instanceof XContentBuilder) {
            updateRequest.doc((XContentBuilder)document);
        } else {
            return null;
        }
        return ((UpdateRequest)updateRequest.waitForActiveShards(((Integer)exchange.getIn().getHeader("waitForActiveShards", Integer.class)).intValue()).parent((String)exchange.getIn().getHeader(PARENT, String.class)).index((String)exchange.getIn().getHeader("indexName", String.class))).type((String)exchange.getIn().getHeader("indexType", String.class)).id((String)exchange.getIn().getHeader("indexId", String.class));
    }

    private static IndexRequest createIndexRequest(Object document, Exchange exchange) {
        if (document instanceof IndexRequest) {
            return (IndexRequest)document;
        }
        IndexRequest indexRequest = new IndexRequest();
        if (document instanceof byte[]) {
            indexRequest.source((byte[])document, XContentFactory.xContentType((byte[])((byte[])document)));
        } else if (document instanceof Map) {
            indexRequest.source((Map)document);
        } else if (document instanceof String) {
            indexRequest.source((String)document, XContentFactory.xContentType((CharSequence)((String)document)));
        } else if (document instanceof XContentBuilder) {
            indexRequest.source((XContentBuilder)document);
        } else {
            return null;
        }
        return ((IndexRequest)((IndexRequest)indexRequest.waitForActiveShards(((Integer)exchange.getIn().getHeader("waitForActiveShards", Integer.class)).intValue())).parent((String)exchange.getIn().getHeader(PARENT, String.class)).index((String)exchange.getIn().getHeader("indexName", String.class))).type((String)exchange.getIn().getHeader("indexType", String.class));
    }

    @Converter
    public static IndexRequest toIndexRequest(Object document, Exchange exchange) {
        return ElasticsearchActionRequestConverter.createIndexRequest(document, exchange).id((String)exchange.getIn().getHeader("indexId", String.class));
    }

    @Converter
    public static UpdateRequest toUpdateRequest(Object document, Exchange exchange) {
        return ElasticsearchActionRequestConverter.createUpdateRequest(document, exchange).id((String)exchange.getIn().getHeader("indexId", String.class));
    }

    @Converter
    public static GetRequest toGetRequest(Object document, Exchange exchange) {
        if (document instanceof GetRequest) {
            return (GetRequest)document;
        }
        return new GetRequest((String)exchange.getIn().getHeader("indexName", String.class)).type((String)exchange.getIn().getHeader("indexType", String.class)).id((String)document);
    }

    @Converter
    public static DeleteRequest toDeleteRequest(Object document, Exchange exchange) {
        if (document instanceof DeleteRequest) {
            return (DeleteRequest)document;
        }
        if (document instanceof String) {
            return ((DeleteRequest)new DeleteRequest().index((String)exchange.getIn().getHeader("indexName", String.class))).type((String)exchange.getIn().getHeader("indexType", String.class)).id((String)document);
        }
        throw new IllegalArgumentException("Wrong body type. Only DeleteRequest or String is allowed as a type");
    }

    @Converter
    public static SearchRequest toSearchRequest(Object queryObject, Exchange exchange) throws IOException {
        if (queryObject instanceof SearchRequest) {
            return (SearchRequest)queryObject;
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{(String)exchange.getIn().getHeader("indexName", String.class)}).types(new String[]{(String)exchange.getIn().getHeader("indexType", String.class)});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        String queryText = null;
        if (queryObject instanceof Map) {
            Map mapQuery = (Map)queryObject;
            if (mapQuery.containsKey(ES_QUERY_DSL_PREFIX)) {
                mapQuery = (Map)mapQuery.get(ES_QUERY_DSL_PREFIX);
            }
            try {
                XContentBuilder contentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.JSON);
                queryText = contentBuilder.map(mapQuery).string();
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
            }
        } else if (queryObject instanceof String) {
            ObjectMapper mapper = new ObjectMapper();
            queryText = (String)queryObject;
            JsonNode jsonTextObject = (JsonNode)mapper.readValue(queryText, JsonNode.class);
            JsonNode parentJsonNode = jsonTextObject.get(ES_QUERY_DSL_PREFIX);
            if (parentJsonNode != null) {
                queryText = parentJsonNode.toString();
            }
        } else {
            return null;
        }
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)queryText));
        searchRequest.source(searchSourceBuilder);
        return searchRequest;
    }

    @Converter
    public static BulkRequest toBulkRequest(Object documents, Exchange exchange) {
        if (documents instanceof BulkRequest) {
            return (BulkRequest)documents;
        }
        if (documents instanceof List) {
            BulkRequest request = new BulkRequest();
            for (Object document : (List)documents) {
                request.add(ElasticsearchActionRequestConverter.createIndexRequest(document, exchange));
            }
            return request;
        }
        throw new IllegalArgumentException("Wrong body type. Only BulkRequest or List is allowed as a type");
    }
}

