/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog.connector;

import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.connector.CamelConnectorCatalog;
import org.apache.camel.catalog.connector.ConnectorDataStore;
import org.apache.camel.catalog.connector.ConnectorDto;
import org.apache.camel.catalog.connector.MemoryConnectorDataStore;

public class DefaultCamelConnectorCatalog
implements CamelConnectorCatalog {
    private final CamelCatalog camelCatalog = new DefaultCamelCatalog(true);
    private ConnectorDataStore dataStore = new MemoryConnectorDataStore();

    @Override
    public void setConnectorDataStore(ConnectorDataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Override
    public boolean hasConnector(String groupId, String artifactId, String version) {
        ConnectorDto dto = new ConnectorDto();
        dto.setGroupId(groupId);
        dto.setArtifactId(artifactId);
        dto.setVersion(version);
        return this.dataStore.hasConnector(dto);
    }

    @Override
    public void addConnector(String groupId, String artifactId, String version, String name, String scheme, String javaType, String description, String labels, String connectorJson, String connectorSchemaJson, String componentSchemaJson) {
        ConnectorDto dto = new ConnectorDto();
        dto.setGroupId(groupId);
        dto.setArtifactId(artifactId);
        dto.setVersion(version);
        dto.setName(name);
        dto.setScheme(scheme);
        dto.setJavaType(javaType);
        dto.setDescription(description);
        dto.setLabels(labels);
        this.dataStore.addConnector(dto, connectorJson, connectorSchemaJson, componentSchemaJson);
    }

    @Override
    public void removeConnector(String groupId, String artifactId, String version) {
        ConnectorDto dto = new ConnectorDto();
        dto.setGroupId(groupId);
        dto.setArtifactId(artifactId);
        dto.setVersion(version);
        this.dataStore.removeConnector(dto);
    }

    @Override
    public List<ConnectorDto> findConnector(boolean latestVersionOnly) {
        return this.findConnector(null, latestVersionOnly);
    }

    @Override
    public List<ConnectorDto> findConnector(String filter, boolean latestVersionOnly) {
        return this.dataStore.findConnector(filter, latestVersionOnly);
    }

    @Override
    public String connectorJSon(String groupId, String artifactId, String version) {
        ConnectorDto dto = new ConnectorDto();
        dto.setGroupId(groupId);
        dto.setArtifactId(artifactId);
        dto.setVersion(version);
        return this.dataStore.connectorJSon(dto);
    }

    @Override
    public String connectorSchemaJSon(String groupId, String artifactId, String version) {
        ConnectorDto dto = new ConnectorDto();
        dto.setGroupId(groupId);
        dto.setArtifactId(artifactId);
        dto.setVersion(version);
        return this.dataStore.connectorSchemaJSon(dto);
    }

    @Override
    public String componentSchemaJSon(String groupId, String artifactId, String version) {
        ConnectorDto dto = new ConnectorDto();
        dto.setGroupId(groupId);
        dto.setArtifactId(artifactId);
        dto.setVersion(version);
        return this.dataStore.componentSchemaJSon(dto);
    }

    @Override
    public String asEndpointUri(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        Optional<ConnectorDto> found = this.dataStore.findConnector(null, true).stream().filter(d -> d.getScheme().equals(scheme)).findAny();
        if (found.isPresent()) {
            ConnectorDto dto = found.get();
            String javaType = dto.getJavaType();
            String componentJson = this.componentSchemaJSon(dto.getGroupId(), dto.getArtifactId(), dto.getVersion());
            this.camelCatalog.addComponent(scheme, javaType, componentJson);
            return this.camelCatalog.asEndpointUri(scheme, properties, encode);
        }
        return null;
    }

    @Override
    public String asEndpointUriXml(String scheme, Map<String, String> properties, boolean encode) throws URISyntaxException {
        Optional<ConnectorDto> found = this.dataStore.findConnector(null, true).stream().filter(d -> d.getScheme().equals(scheme)).findAny();
        if (found.isPresent()) {
            ConnectorDto dto = found.get();
            String javaType = dto.getJavaType();
            String componentJson = this.componentSchemaJSon(dto.getGroupId(), dto.getArtifactId(), dto.getVersion());
            this.camelCatalog.addComponent(scheme, javaType, componentJson);
            return this.camelCatalog.asEndpointUriXml(scheme, properties, encode);
        }
        return null;
    }
}

