/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail.stream;

import com.google.api.client.util.Base64;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.Label;
import com.google.api.services.gmail.model.ListLabelsResponse;
import com.google.api.services.gmail.model.MessagePart;
import com.google.api.services.gmail.model.MessagePartHeader;
import com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.mail.internet.AddressException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamComponent;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConfiguration;
import org.apache.camel.component.google.mail.stream.GoogleMailStreamConsumer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;

@UriEndpoint(firstVersion="2.22.0", scheme="google-mail-stream", title="Google Mail Stream", syntax="google-mail-stream:index", consumerClass=GoogleMailStreamConsumer.class, consumerOnly=true, label="api,cloud,mail")
public class GoogleMailStreamEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private GoogleMailStreamConfiguration configuration;

    public GoogleMailStreamEndpoint(String uri, GoogleMailStreamComponent component, GoogleMailStreamConfiguration endpointConfiguration) {
        super(uri, (Component)component);
        this.configuration = endpointConfiguration;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("The camel google mail stream component doesn't support producer");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        String unreadLabelId = null;
        ArrayList<String> labelsIds = new ArrayList<String>();
        ListLabelsResponse listResponse = (ListLabelsResponse)this.getClient().users().labels().list("me").execute();
        for (Label label : listResponse.getLabels()) {
            Label countLabel = (Label)this.getClient().users().labels().get("me", label.getId()).execute();
            if (!countLabel.getName().equalsIgnoreCase("UNREAD")) continue;
            unreadLabelId = countLabel.getId();
        }
        if (ObjectHelper.isNotEmpty((Object)this.getConfiguration().getLabels())) {
            List<String> plainLabels = this.splitLabels(this.getConfiguration().getLabels());
            for (Label label : listResponse.getLabels()) {
                Label countLabel = (Label)this.getClient().users().labels().get("me", label.getId()).execute();
                for (String plainLabel : plainLabels) {
                    if (!countLabel.getName().equalsIgnoreCase(plainLabel)) continue;
                    labelsIds.add(countLabel.getId());
                }
            }
        }
        GoogleMailStreamConsumer consumer = new GoogleMailStreamConsumer((Endpoint)this, processor, unreadLabelId, labelsIds);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Gmail getClient() {
        return ((GoogleMailStreamComponent)this.getComponent()).getClient(this.configuration);
    }

    public GoogleMailClientFactory getClientFactory() {
        return ((GoogleMailStreamComponent)this.getComponent()).getClientFactory();
    }

    public void setClientFactory(GoogleMailClientFactory clientFactory) {
        ((GoogleMailStreamComponent)this.getComponent()).setClientFactory(clientFactory);
    }

    public GoogleMailStreamConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isSingleton() {
        return true;
    }

    public Exchange createExchange(ExchangePattern pattern, com.google.api.services.gmail.model.Message mail) throws UnsupportedEncodingException {
        Exchange exchange = super.createExchange();
        Message message = exchange.getIn();
        exchange.getIn().setHeader("CamelGoogleMailId", (Object)mail.getId());
        List parts = mail.getPayload().getParts();
        if (parts != null && ((MessagePart)parts.get(0)).getBody().getData() != null) {
            byte[] bodyBytes = Base64.decodeBase64((String)((MessagePart)parts.get(0)).getBody().getData().trim().toString());
            String body = new String(bodyBytes, StandardCharsets.UTF_8);
            message.setBody((Object)body);
        }
        this.setHeaders(message, mail.getPayload().getHeaders());
        return exchange;
    }

    private void setHeaders(Message message, List<MessagePartHeader> headers) {
        for (MessagePartHeader header : headers) {
            String headerName = header.getName();
            if ("SUBJECT".equalsIgnoreCase(headerName)) {
                message.setHeader("CamelGoogleMailStreamSubject", (Object)header.getValue());
            }
            if ("TO".equalsIgnoreCase(headerName)) {
                message.setHeader("CamelGoogleMailStreamTo", (Object)header.getValue());
            }
            if ("FROM".equalsIgnoreCase(headerName)) {
                message.setHeader("CamelGoogleMailStreamFrom", (Object)header.getValue());
            }
            if ("CC".equalsIgnoreCase(headerName)) {
                message.setHeader("CamelGoogleMailStreamCc", (Object)header.getValue());
            }
            if (!"BCC".equalsIgnoreCase(headerName)) continue;
            message.setHeader("CamelGoogleMailStreamBcc", (Object)header.getValue());
        }
    }

    private List<String> splitLabels(String labels) throws AddressException {
        return Splitter.on((char)',').splitToList((CharSequence)labels);
    }
}

