/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.zookeeper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.apache.camel.component.zookeeper.NaturalSortComparator.Order;

import org.junit.Test;

import static org.junit.Assert.assertEquals;

public class NaturalSortComparatorTest {

    @Test
    public void testSortOrder() throws Exception {

        List<String> sorted = Arrays
            .asList(new String[] {"0", "1", "3", "4.0", "11", "30", "55", "225", "333", "camel-2.1.0", "camel-2.1.1", "camel-2.1.1-SNAPSHOT", "camel-2.2.0"});

        List<String> unsorted = new ArrayList<>(sorted);
        Collections.shuffle(unsorted);
        Collections.sort(unsorted, new NaturalSortComparator());
        compareLists(sorted, unsorted);

        Collections.shuffle(unsorted);
        Collections.sort(unsorted, new NaturalSortComparator(Order.Descending));
        Collections.reverse(sorted);
        compareLists(sorted, unsorted);
    }

    private void compareLists(List<String> sorted, List<String> unsorted) {
        for (int x = 0; x < unsorted.size(); x++) {
            assertEquals(sorted.get(x), unsorted.get(x));
        }
    }
}
